/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.qep.QEPJoin;
import com.cognos.xqe.ast.qep.QEPOrderItem;
import com.cognos.xqe.ast.qep.QEPOrdering;
import com.cognos.xqe.ast.qep.QEPPlan;
import com.cognos.xqe.ast.qep.QEPStore;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.resultsets.tabular.Join;
import com.cognos.xqe.resultsets.tabular.Relation;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.transformation.relational.optimization.util.JoinMatrix;
import com.cognos.xqe.transformation.relational.optimization.util.Planner;
import java.util.ArrayList;
import java.util.List;

public class JoinPlanner
extends Planner {
    private static final int JOIN_THRESHOLD = 9;

    public JoinPlanner(IPlanningEnvironment theEnvironment) {
        super(theEnvironment);
    }

    public QEPJoin createJoinPlan(SQLQueryBlock qBlock, IXQEQueryNode root, int nSources) {
        JoinMatrix jMatrix = new JoinMatrix(nSources);
        List<SQLFilter> factorList = qBlock.getFactorList();
        int nFactors = factorList.size();
        for (SQLFilter factor : factorList) {
            FactorAnalyzer.analyze(factor);
            if (factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) {
                jMatrix.set(factor.getLeftSourceNo(), factor.getRightSourceNo());
            }
            if (root.getType() != 301011 || ((SQLJoin)root).getJoinType() != SQLJoin.SubType.FULL_OUTER || factor.getSubType() != 301011 || factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) continue;
            throw new XQERuntimeException(XQEMessageKeys.EXE_UnsupportedFullOuterNonEquiJoin);
        }
        BitMask factors = new BitMask(nFactors);
        factors.set(0, nFactors);
        BitMask toJoin = new BitMask(nSources);
        toJoin.set(0, nSources);
        BitMask joinSet = new BitMask(nSources);
        QEPJoin plan = root.getType() == 301011 ? this.createExplicitJoinPlan(qBlock, (SQLJoin)root, toJoin, factors) : this.createJoinPlan(qBlock, nSources, jMatrix, nSources, toJoin, factors, joinSet);
        return plan;
    }

    public QEPJoin createJoinPlan(SQLQueryBlock qBlock, int nSources, JoinMatrix jMatrix, int nJoin, BitMask toJoin, BitMask unusedFactors, BitMask joinSet) {
        QEPPlan result = null;
        double lowCost = Double.MAX_VALUE;
        BitMask f0 = new BitMask();
        BitMask f1 = new BitMask(unusedFactors);
        BitMask f2 = new BitMask();
        BitMask leftToJoin = new BitMask();
        BitMask recursiveMask = new BitMask();
        List<SQLQueryNode> map = qBlock.getMap();
        for (int i = 0; i < map.size(); ++i) {
            if (!map.get(i).containRecursiveRelation()) continue;
            recursiveMask.set(i);
        }
        for (int s = 0; s < nSources; ++s) {
            leftToJoin.set(toJoin);
            if (!toJoin.get(s)) continue;
            QEPPlan innerPlan = null;
            QEPPlan outerPlan = null;
            leftToJoin.clear(s);
            BitMask incidence = jMatrix.get(s);
            if (!incidence.intersects(toJoin) && joinSet.intersects(leftToJoin)) continue;
            f0.set(f1);
            if (nJoin == 2) {
                int t;
                for (t = 0; t < nSources && !leftToJoin.get(t); ++t) {
                }
                outerPlan = this.createOuterScan(qBlock, t);
            } else {
                outerPlan = this.createJoinPlan(qBlock, nSources, jMatrix, nJoin - 1, leftToJoin, f0, joinSet.lor(incidence));
            }
            if (outerPlan == null) continue;
            f2.set(f0);
            if (recursiveMask.get(s)) continue;
            innerPlan = this.createScan(qBlock, s);
            double nlCost = Double.MAX_VALUE;
            double smCost = Double.MAX_VALUE;
            QEPJoin nlPlan = this.createNestedLoopJoin(qBlock, SQLJoin.SubType.INNER, outerPlan, innerPlan, f0);
            if (nlPlan != null) {
                nlCost = nlPlan.getCost();
            }
            QEPPlan smPlan = null;
            if (recursiveMask.isEmpty()) {
                smPlan = this.createSortMergeJoin(qBlock, SQLJoin.SubType.INNER, toJoin, outerPlan, innerPlan, f2);
            }
            if (smPlan != null) {
                smCost = smPlan.getCost();
            }
            if (smCost <= nlCost) {
                if (nlPlan != null) {
                    this.deletePlan(nlPlan);
                } else {
                    f0.set(f2);
                }
                if (smCost < lowCost || result == null) {
                    unusedFactors.set(f0);
                    if (result != null) {
                        this.deletePlan(result);
                    }
                    result = smPlan;
                    lowCost = smCost;
                } else {
                    this.deletePlan(smPlan);
                }
            } else {
                if (smPlan != null) {
                    this.deletePlan(smPlan);
                }
                if (nlCost < lowCost || result == null) {
                    unusedFactors.set(f0);
                    if (result != null) {
                        this.deletePlan(result);
                    }
                    result = nlPlan;
                    lowCost = nlCost;
                } else {
                    this.deletePlan(nlPlan);
                }
            }
            if (nJoin > 9) break;
        }
        return result;
    }

    public QEPJoin createExplicitJoinPlan(SQLQueryBlock qBlock, SQLJoin jNode, BitMask toJoin, BitMask unusedFactors) {
        QEPPlan plan = null;
        QEPPlan smPlan = null;
        QEPPlan hjPlan = null;
        SQLJoin.SubType joinType = jNode.getJoinType();
        SQLJoin.Hint hint = jNode.getHint();
        BitMask f0 = new BitMask(unusedFactors);
        BitMask f1 = new BitMask();
        QEPPlan outerPlan = this.createOuterScan(qBlock, 0);
        QEPPlan innerPlan = this.createScan(qBlock, 1);
        if (joinType == SQLJoin.SubType.FULL_OUTER && hint == SQLJoin.Hint.STITCH) {
            plan = this.createStitchJoin(qBlock, joinType, toJoin, outerPlan, innerPlan, unusedFactors);
            if (plan != null) {
                unusedFactors.set(f1);
                return plan;
            }
            hint = SQLJoin.Hint.DEFAULT;
        }
        if (hint == SQLJoin.Hint.DEFAULT || hint == SQLJoin.Hint.LOOP) {
            plan = this.createNestedLoopJoin(qBlock, joinType, outerPlan, innerPlan, unusedFactors);
        }
        f1.set(unusedFactors);
        unusedFactors.set(f0);
        if (hint == SQLJoin.Hint.DEFAULT || hint == SQLJoin.Hint.MERGE) {
            smPlan = this.createSortMergeJoin(qBlock, joinType, toJoin, outerPlan, innerPlan, unusedFactors);
        }
        if (plan == null) {
            plan = smPlan;
        } else if (smPlan != null) {
            if (smPlan.getCost() <= plan.getCost()) {
                this.deletePlan(plan);
                plan = smPlan;
            } else {
                this.deletePlan(smPlan);
            }
        }
        f1.set(unusedFactors);
        unusedFactors.set(f0);
        if (hint == SQLJoin.Hint.DEFAULT || hint == SQLJoin.Hint.HASH) {
            hjPlan = this.createHashJoin(qBlock, joinType, toJoin, outerPlan, innerPlan, unusedFactors);
        }
        if (plan == null) {
            plan = hjPlan;
        } else if (hjPlan != null) {
            if (hjPlan.getCost() <= plan.getCost()) {
                this.deletePlan(plan);
                plan = hjPlan;
            } else {
                this.deletePlan(hjPlan);
            }
        }
        unusedFactors.set(f1);
        return plan;
    }

    private QEPJoin createNestedLoopJoin(SQLQueryBlock qBlock, SQLJoin.SubType joinType, QEPPlan outerPlan, QEPPlan innerPlan, BitMask factors) {
        if (joinType == SQLJoin.SubType.FULL_OUTER) {
            return null;
        }
        if (joinType == SQLJoin.SubType.RIGHT_OUTER) {
            QEPPlan tmpPlan = innerPlan;
            innerPlan = outerPlan;
            outerPlan = tmpPlan;
            joinType = SQLJoin.SubType.LEFT_OUTER;
        }
        List<SQLFilter> factorList = qBlock.getFactorList();
        BitMask planFactors = new BitMask(factorList.size());
        BitMask incidence = outerPlan.getIncidence().lor(innerPlan.getIncidence());
        double nRows = outerPlan.getCardinality() * innerPlan.getCardinality();
        if (!innerPlan.isLateralDerivedTable()) {
            QEPStore storePlan = (QEPStore)this.createPlan(901010);
            storePlan.addPlan(innerPlan);
            storePlan.setSourceNo(innerPlan.getSourceNo());
            storePlan.setIncidence(innerPlan.getIncidence());
            storePlan.setCardinalityEstimate(innerPlan.getCardinality());
            storePlan.setNumberColumns(innerPlan.getNumberColumns());
            storePlan.computeCosts();
            innerPlan = storePlan;
            int i = 0;
            for (SQLFilter factor : factorList) {
                if (factors.get(i) && factor.getIncidence().land(incidence).equals(factor.getIncidence())) {
                    planFactors.set(i);
                    factors.clear(i);
                    nRows *= factor.getSelectivity();
                }
                ++i;
            }
        }
        QEPJoin plan = planFactors.isEmpty() ? (QEPJoin)this.createPlan(901012) : (QEPJoin)this.createPlan(901013);
        plan.setJoinType(joinType);
        plan.addPlan(outerPlan);
        plan.addPlan(innerPlan);
        plan.setIncidence(incidence);
        plan.setNumberColumns(outerPlan.getNumberColumns() + innerPlan.getNumberColumns());
        plan.setLateral(innerPlan.isLateralDerivedTable());
        plan.computeCosts();
        plan.setCardinalityEstimate(nRows);
        plan.setFactors(planFactors);
        return plan;
    }

    private QEPJoin createSortMergeJoin(SQLQueryBlock qBlock, SQLJoin.SubType joinType, BitMask toJoin, QEPPlan outerPlan, QEPPlan innerPlan, BitMask factors) {
        List<SQLFilter> factorList = qBlock.getFactorList();
        if (joinType != SQLJoin.SubType.INNER) {
            for (SQLFilter factor : factorList) {
                if (factor.getSubType() != 301011 || factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) continue;
                return null;
            }
        }
        return this.buildJoinPlan(qBlock, joinType, 901014, toJoin, outerPlan, innerPlan, factors);
    }

    private QEPJoin createHashJoin(SQLQueryBlock qBlock, SQLJoin.SubType joinType, BitMask toJoin, QEPPlan outerPlan, QEPPlan innerPlan, BitMask factors) {
        List<SQLFilter> factorList = qBlock.getFactorList();
        if (joinType == SQLJoin.SubType.FULL_OUTER) {
            return null;
        }
        if (joinType == SQLJoin.SubType.LEFT_OUTER) {
            for (SQLFilter factor : factorList) {
                if (factor.getSubType() != 301011 || factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) continue;
                return null;
            }
            QEPPlan tmpPlan = innerPlan;
            innerPlan = outerPlan;
            outerPlan = tmpPlan;
            joinType = SQLJoin.SubType.RIGHT_OUTER;
        }
        return this.buildJoinPlan(qBlock, joinType, 901015, toJoin, outerPlan, innerPlan, factors);
    }

    private QEPJoin createStitchJoin(SQLQueryBlock qBlock, SQLJoin.SubType joinType, BitMask toJoin, QEPPlan outerPlan, QEPPlan innerPlan, BitMask factors) {
        return this.buildJoinPlan(qBlock, joinType, 901022, toJoin, outerPlan, innerPlan, factors);
    }

    private QEPJoin buildJoinPlan(SQLQueryBlock qBlock, SQLJoin.SubType joinType, int planType, BitMask toJoin, QEPPlan outerPlan, QEPPlan innerPlan, BitMask factors) {
        List<SQLFilter> factorList = qBlock.getFactorList();
        QEPOrdering oOrder = (QEPOrdering)this.createPlan(901018);
        QEPOrdering iOrder = (QEPOrdering)this.createPlan(901018);
        int sourceNo = innerPlan.getSourceNo();
        BitMask sourceSet = new BitMask(toJoin);
        sourceSet.clear(sourceNo);
        double selectivity = this.findEquiJoins(factorList, sourceNo, sourceSet, oOrder, iOrder);
        if (oOrder.getNumberChildren() == 0) {
            this.deletePlan(oOrder);
            this.deletePlan(iOrder);
            return null;
        }
        QEPJoin plan = (QEPJoin)this.createPlan(planType);
        BitMask planFactors = new BitMask(factorList.size());
        ArrayList<SQLFilter> equiJoinFactorList = new ArrayList<SQLFilter>();
        int i = 0;
        for (SQLFilter factor : factorList) {
            if (factors.get(i) && factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN && factor.getSubType() == 301011 && factor.getIncidence().land(toJoin).equals(factor.getIncidence())) {
                equiJoinFactorList.add(factor);
                planFactors.set(i);
                factors.clear(i);
            }
            ++i;
        }
        if (outerPlan.getParent() != null) {
            outerPlan = (QEPPlan)this.factory.deepCopyNode(outerPlan);
        }
        if (innerPlan.getParent() != null) {
            innerPlan = (QEPPlan)this.factory.deepCopyNode(innerPlan);
        }
        if (planType == 901014 || planType == 901022) {
            boolean pushable = true;
            List<SQLQueryNode> map = qBlock.getMap();
            for (SQLQueryNode child : map) {
                if (child.getType() != 301004 || child.getChild(0).getType() != 301052) continue;
                pushable = false;
            }
            outerPlan = this.createOrderedScan(qBlock, outerPlan, oOrder, pushable);
            innerPlan = this.createOrderedScan(qBlock, innerPlan, iOrder, pushable);
        }
        plan.addPlan(outerPlan);
        plan.addPlan(innerPlan);
        plan.setJoinType(joinType);
        plan.setIncidence(outerPlan.getIncidence().lor(innerPlan.getIncidence()));
        plan.computeCosts();
        double nRows = outerPlan.getCardinality() * innerPlan.getCardinality() * selectivity;
        i = 0;
        for (SQLFilter factor : factorList) {
            if (factors.get(i) && factor.getSubType() == 301011 && factor.getIncidence().land(plan.getIncidence()).equals(factor.getIncidence())) {
                factors.clear(i);
                planFactors.set(i);
                nRows *= factor.getSelectivity();
            }
            ++i;
        }
        ArrayList<Join> joins = new ArrayList<Join>(iOrder.getNumberJoinKeys());
        for (int j = 0; j < iOrder.getNumberChildren(); ++j) {
            QEPOrderItem outerItem = (QEPOrderItem)oOrder.getChild(j);
            QEPOrderItem innerItem = (QEPOrderItem)iOrder.getChild(j);
            boolean exists = false;
            for (Join join : joins) {
                Relation leftJoin = join.getLeftJoin();
                Relation rightJoin = join.getRightJoin();
                if (leftJoin.getColumnNo() != outerItem.getColumnNo() || rightJoin.getColumnNo() != innerItem.getColumnNo()) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            Join join = new Join(new Relation(outerItem.getColumnNo()), new Relation(innerItem.getColumnNo()));
            SQLExpression predicate = ((SQLFilter)equiJoinFactorList.get(j)).getPredicate();
            if (predicate.getType() == 301075 && ((SQLIsDistinctFrom)predicate).isNegated()) {
                join.setIsNotDistinctFrom(true);
            }
            joins.add(join);
        }
        plan.setJoins(joins);
        plan.setCardinalityEstimate(nRows);
        plan.setFactors(planFactors);
        plan.setNumberColumns(outerPlan.getNumberColumns() + innerPlan.getNumberColumns());
        return plan;
    }

    public static int getVirtualColumnNumber(int[] joinOrder, int[] nColumns, SQLFid fid) {
        return JoinPlanner.getVirtualColumnNumber(joinOrder, nColumns, fid.getSourceNo(), fid.getColumnNo());
    }

    public static int getVirtualColumnNumber(int[] joinOrder, int[] nColumns, QEPOrderItem orderItem) {
        return JoinPlanner.getVirtualColumnNumber(joinOrder, nColumns, orderItem.getSourceNo(), orderItem.getColumnNo());
    }

    private static int getVirtualColumnNumber(int[] joinOrder, int[] nColumns, int sourceNo, int columnNo) {
        int joinPos = joinOrder[sourceNo];
        int vColumnNo = columnNo;
        if (joinPos > 0) {
            vColumnNo += nColumns[joinPos - 1];
        }
        return vColumnNo;
    }

    private double findEquiJoins(List<SQLFilter> factorList, int iSourceNo, BitMask sourceSet, QEPOrdering oOrder, QEPOrdering iOrder) {
        double selectivity = 1.0;
        for (SQLFilter factor : factorList) {
            QEPOrderItem iOrderItem;
            QEPOrderItem oOrderItem;
            if (factor.getSubType() != 301011 || factor.getFactorType() != FactorAnalyzer.FactorType.EQUIJOIN || !factor.getIncidence().get(iSourceNo)) continue;
            SQLExpression node = factor.getPredicate();
            SQLFid fidL = (SQLFid)node.getChild(0);
            SQLFid fidR = (SQLFid)node.getChild(1);
            int lSourceNo = factor.getLeftSourceNo();
            int rSourceNo = factor.getRightSourceNo();
            if (sourceSet.get(lSourceNo)) {
                selectivity *= factor.getSelectivity();
                oOrderItem = this.createOrderItem(lSourceNo, fidL.getColumnNo(), fidL.getDataType());
                iOrderItem = this.createOrderItem(rSourceNo, fidR.getColumnNo(), fidR.getDataType());
                oOrder.addChild(oOrderItem);
                iOrder.addChild(iOrderItem);
                continue;
            }
            if (iSourceNo != lSourceNo || !sourceSet.get(rSourceNo)) continue;
            selectivity *= factor.getSelectivity();
            oOrderItem = this.createOrderItem(rSourceNo, fidR.getColumnNo(), fidR.getDataType());
            iOrderItem = this.createOrderItem(lSourceNo, fidL.getColumnNo(), fidL.getDataType());
            oOrder.addChild(oOrderItem);
            iOrder.addChild(iOrderItem);
        }
        oOrder.setNumberJoinKeys(oOrder.getNumberChildren());
        iOrder.setNumberJoinKeys(iOrder.getNumberChildren());
        return selectivity;
    }
}

