/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization.util;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.qep.QEPAbstractPlan;
import com.cognos.xqe.ast.qep.QEPOrderItem;
import com.cognos.xqe.ast.qep.QEPOrdering;
import com.cognos.xqe.ast.qep.QEPPlan;
import com.cognos.xqe.ast.qep.QEPScan;
import com.cognos.xqe.ast.qep.QEPSort;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Planner {
    protected IPlanningEnvironment environment;
    protected XQENodeFactory factory;
    private Map<Integer, List<QEPAbstractPlan>> planCache = new HashMap<Integer, List<QEPAbstractPlan>>();

    public Planner(IPlanningEnvironment theEnvironment) {
        this.environment = theEnvironment;
        this.factory = this.environment.getNodeFactory();
    }

    public QEPAbstractPlan createPlan(int planType) {
        List<QEPAbstractPlan> plans = this.planCache.get(planType);
        if (plans == null) {
            plans = new LinkedList<QEPAbstractPlan>();
            this.planCache.put(planType, plans);
        }
        QEPAbstractPlan plan = plans.isEmpty() ? (QEPAbstractPlan)this.factory.createNode(planType) : plans.remove(0);
        plan.initialize();
        return plan;
    }

    public void deletePlan(QEPAbstractPlan plan) {
        List<QEPAbstractPlan> plans = this.planCache.get(plan.getType());
        plans.add((QEPAbstractPlan)plan.detach());
        for (IXQEQueryNode tmpPlan : plan.getChildren()) {
            this.deletePlan((QEPAbstractPlan)tmpPlan);
        }
    }

    protected QEPPlan createScan(SQLQueryBlock qBlock, int sourceNo) {
        QEPScan plan = (QEPScan)this.createPlan(901011);
        ISQLQueryNode qNode = qBlock.getMap().get(sourceNo);
        BitMask incidence = new BitMask();
        incidence.set(sourceNo);
        plan.setSourceNo(sourceNo);
        plan.setIncidence(incidence);
        plan.setCardinalityEstimate(qNode.getCardinality());
        plan.setNumberColumns(qNode.getNumberColumns());
        plan.computeCosts();
        plan.setLateral(qNode.isLateralDerivedTable());
        return plan;
    }

    protected QEPPlan createOuterScan(SQLQueryBlock qBlock, int sourceNo) {
        ISQLQueryNode child = qBlock.getMap().get(sourceNo);
        if (child.isLateralDerivedTable()) {
            return null;
        }
        return this.createScan(qBlock, sourceNo);
    }

    protected QEPSort createOrderedScan(SQLQueryBlock qBlock, QEPPlan inputPlan, QEPOrdering ordering, boolean pushable) {
        QEPSort plan = (QEPSort)this.createPlan(901009);
        plan.addPlan(inputPlan);
        plan.addPlan(ordering);
        plan.setCardinalityEstimate(inputPlan.getCardinality());
        plan.setIncidence(inputPlan.getIncidence());
        plan.computeCosts();
        plan.setPushable(pushable);
        plan.setCollationIdRequired(true);
        plan.setNumberColumns(inputPlan.getNumberColumns());
        return plan;
    }

    public QEPOrderItem createOrderItem(int sourceNo, int columnNo, IDataType dataType) {
        QEPOrderItem orderItem = (QEPOrderItem)this.createPlan(901019);
        orderItem.setSourceNo(sourceNo);
        orderItem.setColumnNo(columnNo);
        orderItem.setDataType(dataType);
        return orderItem;
    }
}

