/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLOrdinalDecoration;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.data.types.DataTypeFactory;
import java.util.ArrayList;
import java.util.List;

public class RestoreOlapMemberOrderUtil {
    public static SQLOrdinalDecoration createOrderColumn(IXQEQueryNode node, XQENodeFactory nodeFactory) {
        SQLOrdinalDecoration orderColumn = (SQLOrdinalDecoration)nodeFactory.createNode(301081);
        node.getChild(0).insertParent(orderColumn);
        return orderColumn;
    }

    public static void createSortByOrderColumn(IXQEQueryNode node, XQENodeFactory nodeFactory) {
        SQLSort sortRN = (SQLSort)nodeFactory.createNode(301019);
        sortRN.setCollationIdRequired(false);
        SQLSortKeyList sortKeyList = (SQLSortKeyList)nodeFactory.createNode(301021);
        SQLSortKey sortKey = (SQLSortKey)nodeFactory.createNode(301020);
        SQLValueList valueList = (SQLValueList)node.getFirstChildByType(301030);
        int columnNo = valueList.getNumberChildren() - 1;
        SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
        fid.setName(valueList.getName(columnNo));
        fid.setSourceNo(0);
        fid.setColumnNo(columnNo);
        fid.setVirtualColumnNo(columnNo);
        fid.setDataType(DataTypeFactory.getLongType());
        sortKey.addChild(fid);
        sortKey.setAscending(true);
        node.insertParent(sortRN);
        sortKeyList.addChild(sortKey);
        sortRN.addChild(sortKeyList);
    }

    public static void propagateOrderColumn(SQLFid fid, XQENodeFactory nodeFactory) {
        int[] types = new int[]{301015, 901021};
        IXQEQueryNode node = fid.getAncestorOfType(types).getParent();
        IXQEQueryNode prev = null;
        while (node.getType() != 301015) {
            if (node.getType() == 301014) {
                IXQEQueryNode[] fids;
                int pos = node.getPositionOfChild(prev);
                for (IXQEQueryNode f : fids = node.getAncestorOfType(301015).getFirstChildByType(301030).getChildren()) {
                    SQLFid fi = (SQLFid)f;
                    if (fi.getSourceNo() <= pos) continue;
                    fi.setVirtualColumnNo(fi.getVirtualColumnNo() + 1);
                }
            } else {
                if (node.getType() == 301008) {
                    RestoreOlapMemberOrderUtil.stopPropagationByProject(fid, prev, nodeFactory);
                    break;
                }
                if (node.getType() == 301018) {
                    RestoreOlapMemberOrderUtil.stopPropagationByProject(fid, prev, nodeFactory);
                    break;
                }
                if (node.getType() == 601013) break;
            }
            prev = node;
            node = node.getParent();
        }
    }

    static void stopPropagationByProject(SQLFid fid, IXQEQueryNode node, XQENodeFactory nodeFactory) {
        IXQEQueryNode project = nodeFactory.createNode(301015);
        node.insertParent(project);
        SQLValueList list = (SQLValueList)nodeFactory.createNode(301030);
        project.addChild(list);
        SQLValueList valueListWithOrderColumn = (SQLValueList)fid.getAncestorOfType(301030);
        List<SQLAlias> listAlias = valueListWithOrderColumn.getAliasList();
        IXQEQueryNode[] columns = valueListWithOrderColumn.getChildren();
        list.setAliasList(new ArrayList<SQLAlias>());
        for (int columnNo = 0; columnNo < columns.length - 1; ++columnNo) {
            SQLAlias alias = listAlias.get(columnNo);
            SQLFid fidNew = (SQLFid)nodeFactory.createNode(301032);
            fidNew.setName(alias.getName());
            fidNew.setSourceNo(0);
            fidNew.setColumnNo(columnNo);
            fidNew.setVirtualColumnNo(columnNo);
            fidNew.setDataType(((SQLQueryNode)columns[columnNo]).getDataType());
            list.addChild(fidNew);
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName(alias.getName());
            list.getAliasList().add(aliasNode);
        }
    }

    public static boolean explicitlySortedResultset(IXQEQueryNode node) {
        int[] ancestorType = new int[]{301019, 301015};
        for (IXQEQueryNode current = node.getAncestorOfTypes(ancestorType); current != null; current = current.getAncestorOfTypes(ancestorType)) {
            if (current.getType() == 301019) {
                IXQEQueryNode[] sortKeys;
                Boolean att = current.getBooleanPropertyValue("window.aggregate");
                if (att != null && att != Boolean.FALSE) continue;
                for (IXQEQueryNode key : sortKeys = ((SQLSort)current).getSortKeyList().getChildren()) {
                    SQLFid fid = (SQLFid)key.getChild(0);
                    if (!fid.getDataType().isNumeric()) continue;
                    return true;
                }
                continue;
            }
            if (!((SQLProject)current).getMemberOrdered()) continue;
            return false;
        }
        return false;
    }

    public static V5QuerySet getTopMostQuerySet(IXQEQueryNode node) {
        IXQEQueryNode qs = null;
        for (IXQEQueryNode current = node.getAncestorOfType(101002); current != null; current = current.getAncestorOfType(101002)) {
            qs = current;
        }
        return (V5QuerySet)qs;
    }

    public static boolean isOlapBased(IXQEQueryNode node) {
        boolean ret;
        boolean bl = ret = node.getFirstDescendantOfTypeOrdered(301052, false) != null;
        if (!ret) {
            IXQEQueryNode[] sqlRelations = node.getDescendantsOfType(301016, false);
            IXQEQueryNode sqlWith = node.getAncestorOfType(301022);
            if (sqlWith != null) {
                ArrayList<String> queriesOlap = new ArrayList<String>();
                IXQEQueryNode[] sqlQB = sqlWith.getChildren();
                for (int i = 0; i < sqlQB.length - 1; ++i) {
                    IXQEQueryNode flatten = sqlQB[i].getFirstDescendantOfTypeOrdered(301052, false);
                    if (flatten == null) continue;
                    SQLQueryBlock qB = (SQLQueryBlock)sqlQB[i].getFirstDescendantOfTypeOrdered(301004, true);
                    queriesOlap.add(qB.getName());
                }
                for (IXQEQueryNode current : sqlRelations) {
                    if (!queriesOlap.contains(current.getPropertyValue("name"))) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }
}

