/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunctionSubtype;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.Measure;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelAttributeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public final class AdjustRSAPIDataItemDataTypesRelationalCrosstab
extends RQETransformation {
    private static final String ADJUSTED = "datatypeAdjusted";

    public AdjustRSAPIDataItemDataTypesRelationalCrosstab() {
        this.mName = "Adjust data types in relational crosstab.";
        this.mPassNumbers = new int[]{27};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        RSAPIEdge[] edges;
        node.setPropertyValue(ADJUSTED, Boolean.TRUE);
        this.adjustWrapperObjectDataType(node);
        IXQEQueryNode dataSet = node.getAncestorOfType(401005);
        IXQEQueryNode querySet = dataSet.getAncestorOfType(101002);
        V5Query query = ((V5QuerySet)querySet).getV5Query(((RSAPIDataset)dataSet).getRefQueryName());
        V5Selection select = query.getV5Selection();
        for (RSAPIEdge edge : edges = ((RSAPIDataset)dataSet).getEdges()) {
            RSAPIEdgeRowset[] rowSets;
            for (RSAPIEdgeRowset rowSet : rowSets = edge.getRowsets()) {
                AggregateTypeEnum[] simpleAggr;
                RSAPIDataItem dataItem = rowSet.getRefDataItem();
                V5DataItem v5DataItem = select.getDataItemByRefName(dataItem.getName());
                if (this.dataItemUseMeasures(v5DataItem, simpleAggr = new AggregateTypeEnum[]{null})) {
                    IDataType dt1 = v5DataItem.getDataType();
                    if (dt1 instanceof DecimalType && dataItem.getUsage() == RSAPIUsage.FACT) {
                        dt1 = this.adjustDataTypeForReportSummary(dt1, rowSet, edges, edge, select, simpleAggr[0]);
                    }
                    IDataType dt = dataItem.getDataType();
                    if (dt1 == null || dt != null && dt.equals(dt1) || dt1 == DataTypeFactory.getVariantType()) continue;
                    dataItem.setDataType(dt1);
                    continue;
                }
                this.updateDataItemDataTypeForLevelAndProperties(rowSet, v5DataItem);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getPropertyValue(ADJUSTED) == null) {
            MDXFromCube fromCube = (MDXFromCube)node.getFirstChildByType(1007);
            ICube cube = fromCube.getCube();
            status = this.isCubeWrapperForRelationalXtab(cube);
        }
        if (status) {
            this.traceQueryCondition(status, "Data types need to be adjusted in relational crsstab.", trace);
        } else {
            this.traceQueryCondition(status, "Data types don't need to be adjusted for MDXQuery.", trace);
        }
        return status;
    }

    protected boolean isCubeWrapperForRelationalXtab(ICube cube) {
        if (cube == null || !(cube instanceof CubeWrapper)) {
            return false;
        }
        return ((CubeWrapper)cube).getTabularResultSetName() != null;
    }

    protected void adjustWrapperObjectDataType(IXQEQueryNode node) {
        MDXFromCube fromCube = (MDXFromCube)node.getFirstChildByType(1007);
        ICube cube = fromCube.getCube();
        String tabName = ((CubeWrapper)cube).getTabularResultSetName();
        RSAPIDataItem[] dataItems = null;
        IXQEQueryNode querySet = node.getAncestorOfType(101002);
        for (int i = 0; i < querySet.getNumberChildren(); ++i) {
            V5Query v5Query;
            IXQEQueryNode child = querySet.getChild(i);
            if (child.getType() != 101006 || !(v5Query = (V5Query)child).getV5QueryName().equals(tabName)) continue;
            RSAPIDataset dataSet = (RSAPIDataset)v5Query.getFirstChildByType(401005);
            RSAPIEdge edge = dataSet.getEdge(0);
            RSAPIEdgeRowset rowSet = edge.getRootRowset();
            dataItems = rowSet.getDataItems();
            break;
        }
        if (dataItems == null || dataItems.length == 0) {
            return;
        }
        this.adjustMeasureDataType(cube.getMeasureDimension().getDefaultHierarchy().getLevel(0).getMembers(), dataItems);
        this.adjustLevelAndPropertyDataType(cube.getDimensions(), dataItems);
    }

    protected void adjustMeasureDataType(List<IMember> measures, RSAPIDataItem[] dataItems) {
        for (IMember aMeasure : measures) {
            int colPos;
            IDataType dt1;
            HashMap rollUp;
            Measure measure = (Measure)aMeasure;
            IDataType dt = measure.getDataType();
            String column = (String)aMeasure.getProperty("expression");
            if (column == null && (rollUp = (HashMap)measure.getProperty("externalRollUpScopes")) != null) {
                TreeSet sortByName = new TreeSet(rollUp.values());
                column = (String)sortByName.first();
            }
            if (column == null || (dt1 = dataItems[colPos = Integer.parseInt(column)].getDataType()).equals(dt) || dt1 == DataTypeFactory.getVariantType()) continue;
            measure.setDataType(dt1);
        }
    }

    protected void adjustLevelAndPropertyDataType(List<IDimension> dims, RSAPIDataItem[] dataItems) {
        for (IDimension dim : dims) {
            if (dim.isMeasuresDimension()) continue;
            List<ILevel> levels = dim.getDefaultHierarchy().getLevels();
            for (ILevel level : levels) {
                List<IMetadata> childrenMeta;
                if (!(level instanceof V5DataItemToLevelWrapper)) continue;
                V5DataItemToLevelWrapper lvl = (V5DataItemToLevelWrapper)level;
                String column = (String)lvl.getProperty("expression");
                if (column != null) {
                    int colPos = Integer.parseInt(column);
                    IDataType dt1 = dataItems[colPos].getDataType();
                    IDataType dt = lvl.getNativeDataType();
                    if (!(dt1 == null || dt != null && dt.equals(dt1) || dt1 == DataTypeFactory.getVariantType())) {
                        lvl.setDataType(dt1);
                    }
                }
                if ((childrenMeta = level.getChildMetadataObjects()) == null) continue;
                for (IMetadata meta : childrenMeta) {
                    V5DataItemToLevelAttributeWrapper prop;
                    if (!(meta instanceof V5DataItemToLevelAttributeWrapper) || (column = (String)(prop = (V5DataItemToLevelAttributeWrapper)meta).getProperty("expression")) == null) continue;
                    int colPos = Integer.parseInt(column);
                    IDataType dt1 = dataItems[colPos].getDataType();
                    IDataType dt = prop.getDataType();
                    if (dt1 == null || dt != null && dt.equals(dt1) || dt1 == DataTypeFactory.getVariantType()) continue;
                    prop.setDataType(dt1);
                }
            }
        }
    }

    protected boolean dataItemUseMeasures(V5DataItem v5DataItem, AggregateTypeEnum[] simpleAggr) {
        IXQEQueryNode[] objs;
        for (IXQEQueryNode obj : objs = v5DataItem.getDescendantsOfType(201116, false)) {
            V5BoundModelIdentifier modelIdentifier = (V5BoundModelIdentifier)obj;
            if (!modelIdentifier.isMeasure()) continue;
            if (v5DataItem == modelIdentifier.getParent()) {
                simpleAggr[0] = ((V5DataItemToMeasureWrapper)modelIdentifier.getMetadata()).getRegularAggregate();
            }
            return true;
        }
        return false;
    }

    protected void updateDataItemDataTypeForLevelAndProperties(RSAPIEdgeRowset rowSet, V5DataItem v5DataItem) {
        RSAPIDataItem[] dataItems;
        if (v5DataItem.getNumberChildren() != 1) {
            return;
        }
        IXQEQueryNode exp = v5DataItem.getChild(0);
        if (exp.getType() != 201086) {
            return;
        }
        IXQEQueryNode meta = exp.getChild(0);
        if (meta == null || meta.getType() != 201116) {
            return;
        }
        V5BoundModelIdentifier modelIdentifier = (V5BoundModelIdentifier)meta;
        IMetadata mdObject = modelIdentifier.getMetadata();
        if (!(mdObject instanceof V5DataItemToLevelWrapper)) {
            return;
        }
        RSAPIDataItem dataItemLvl = rowSet.getRefDataItem();
        V5DataItemToLevelWrapper lvl = (V5DataItemToLevelWrapper)mdObject;
        IDataType dt1 = lvl.getNativeDataType();
        IDataType dt = dataItemLvl.getDataType();
        if (!(dt1 == null || dt != null && dt.equals(dt1) || dt1 == DataTypeFactory.getVariantType() || dt == MemberType.MEMBERTYPE && dt1.isTextType())) {
            dataItemLvl.setDataType(dt1);
        }
        if ((dataItems = rowSet.getDataItems()) == null) {
            return;
        }
        for (RSAPIDataItem dataItem : dataItems) {
            String propName = dataItem.getPropertyName();
            V5DataItemToLevelAttributeWrapper prop = this.getPropertyByName(lvl, propName);
            if (prop == null) continue;
            dt1 = prop.getDataType();
            dt = dataItem.getPropertyDataType();
            if (dt1 == null || dt != null && dt.equals(dt1) || dt1 == DataTypeFactory.getVariantType()) continue;
            dataItem.setPropertyDataType(dt1);
        }
    }

    protected V5DataItemToLevelAttributeWrapper getPropertyByName(ILevel level, String propName) {
        if (propName == null) {
            return null;
        }
        List<IMetadata> childrenMeta = level.getChildMetadataObjects();
        if (childrenMeta == null) {
            return null;
        }
        for (IMetadata meta : childrenMeta) {
            V5DataItemToLevelAttributeWrapper prop;
            String uniqueName;
            if (!(meta instanceof V5DataItemToLevelAttributeWrapper) || !propName.equals(uniqueName = (prop = (V5DataItemToLevelAttributeWrapper)meta).getV5UniqueName())) continue;
            return prop;
        }
        return null;
    }

    protected IDataType adjustDataTypeForReportSummary(IDataType dt1, RSAPIEdgeRowset theRowSet, RSAPIEdge[] edges, RSAPIEdge theEdge, V5Selection select, AggregateTypeEnum aggr) {
        if (!(dt1 instanceof DecimalType)) {
            return dt1;
        }
        if (theRowSet.getNestedRowset() != null) {
            return dt1;
        }
        HashSet[] involvedAggr = new HashSet[edges.length];
        RSAPIDataItem dataItem = null;
        V5DataItem v5DataItem = null;
        AggregateTypeEnum aggregate = null;
        for (int i = 0; i < edges.length; ++i) {
            RSAPIEdgeRowset[] rowSets;
            RSAPIEdge edge = edges[i];
            if (edge == theEdge) {
                RSAPIEdgeRowset parentRowset = theRowSet.getParentRowset();
                if (parentRowset == null || (aggregate = this.getAggregate(v5DataItem = select.getDataItemByRefName((dataItem = parentRowset.getRefDataItem()).getName()))) == null) continue;
                if (aggr == null) {
                    return DataTypeFactory.getDecimalType(256, Math.max(dt1.getScale(), 128));
                }
                if (aggregate == AggregateTypeEnum.UNKNOWN) {
                    aggregate = aggr;
                }
                if (aggregate == AggregateTypeEnum.UNKNOWN) continue;
                if (involvedAggr[i] == null) {
                    involvedAggr[i] = new HashSet();
                }
                involvedAggr[i].add(aggregate);
                continue;
            }
            RSAPIEdgeRowset[] rSAPIEdgeRowsetArray = rowSets = edge.getRowsets();
            int n = rSAPIEdgeRowsetArray.length;
            for (int j = 0; j < n; ++j) {
                RSAPIEdgeRowset rowSet = rSAPIEdgeRowsetArray[j];
                if (rowSet.getNestedRowset() != null || (aggregate = this.getAggregate(v5DataItem = select.getDataItemByRefName((dataItem = rowSet.getRefDataItem()).getName()))) == null) continue;
                if (aggr == null) {
                    return DataTypeFactory.getDecimalType(256, Math.max(dt1.getScale(), 128));
                }
                if (aggregate == AggregateTypeEnum.UNKNOWN) {
                    aggregate = aggr;
                }
                if (aggregate == AggregateTypeEnum.UNKNOWN) continue;
                if (involvedAggr[i] == null) {
                    involvedAggr[i] = new HashSet();
                }
                involvedAggr[i].add(aggregate);
            }
        }
        DecimalType newDataType = DataTypeFactory.getDecimalType(dt1.getPrecision(), dt1.getScale());
        boolean bAdjusted = false;
        for (HashSet aset : involvedAggr) {
            if (aset == null) continue;
            int maxPre = -1;
            int maxScale = -1;
            for (AggregateTypeEnum a : aset) {
                IDataType d = a.getPostAggregationDataType(newDataType);
                if (!(d instanceof DecimalType)) continue;
                int p = d.getPrecision();
                int s = d.getScale();
                if (p > maxPre) {
                    maxPre = p;
                }
                if (s <= maxScale) continue;
                maxScale = s;
            }
            if (maxPre <= newDataType.getPrecision() && maxScale <= newDataType.getScale()) continue;
            newDataType = DataTypeFactory.getDecimalType(Math.max(maxPre, newDataType.getPrecision()), Math.max(maxScale, newDataType.getScale()));
            bAdjusted = true;
        }
        if (bAdjusted) {
            return newDataType;
        }
        return dt1;
    }

    protected AggregateTypeEnum getAggregate(V5DataItem v5DataItem) {
        IXQEQueryNode[] children = v5DataItem.getChildren();
        if (children == null || children.length != 1) {
            return null;
        }
        IXQEQueryNode expr = children[0];
        if (expr.getType() == 101004) {
            expr = expr.getChild(0);
        }
        if (expr.getType() == 201085) {
            expr = expr.getChild(0);
        }
        if (expr.getType() != 201032 || expr.getNumberChildren() != 2) {
            return null;
        }
        IXQEQueryNode child0 = expr.getChild(0);
        IXQEQueryNode[] tmp = child0.getChildren();
        while (tmp.length > 0) {
            if (tmp.length != 1) {
                return null;
            }
            child0 = tmp[0];
            tmp = child0.getChildren();
        }
        if (child0.getType() != 201058) {
            return null;
        }
        IXQEQueryNode child1 = expr.getChild(1);
        if (child1.getType() != 201039) {
            return null;
        }
        String aggrType = V5AggregateFunctionSubtype.getName(((V5MemberSummaryFunction)expr).getSubType());
        if (aggrType == null) {
            return null;
        }
        return AggregateTypeEnum.valueOfV5String(aggrType);
    }
}

