/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ApplyAbsorptionLaws
extends RQETransformation {
    public ApplyAbsorptionLaws() {
        this.mName = "Apply boolean algebra absorption laws.";
        this.mPassNumbers = new int[]{8, 10};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mTypes = new int[]{301027};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        if (node.getChild(1).getType() == 301027) {
            parent.exchangeChildNode(node, node.detachChild(0), false);
        } else {
            parent.exchangeChildNode(node, node.detachChild(1), false);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = dataSource == null || !dataSource.isRelational() || dataSource.getCapabilities().isSupported("performance.transitiveClosure") || dataSource.getCapabilities().isSupported("performance.predicatePushdown") || !node.isSupported(dataSource);
        if (status) {
            status = false;
            SQLLogical.SubType subType = ((SQLLogical)node).getSubType();
            if (subType == SQLLogical.SubType.AND || subType == SQLLogical.SubType.OR) {
                IXQEQueryNode lChild = node.getChild(0);
                IXQEQueryNode rChild = node.getChild(1);
                if (subType == SQLLogical.SubType.OR) {
                    if (rChild.getType() == 301027 && ((SQLLogical)rChild).getSubType() == SQLLogical.SubType.AND) {
                        status = lChild.isSameExpression(rChild.getChild(0), false) || lChild.isSameExpression(rChild.getChild(1), false);
                    } else if (lChild.getType() == 301027 && ((SQLLogical)lChild).getSubType() == SQLLogical.SubType.AND) {
                        status = rChild.isSameExpression(lChild.getChild(0), false) || rChild.isSameExpression(lChild.getChild(1), false);
                    }
                } else if (subType == SQLLogical.SubType.AND) {
                    if (rChild.getType() == 301027 && ((SQLLogical)rChild).getSubType() == SQLLogical.SubType.OR) {
                        status = lChild.isSameExpression(rChild.getChild(0), false) || lChild.isSameExpression(rChild.getChild(1), false);
                    } else if (lChild.getType() == 301027 && ((SQLLogical)lChild).getSubType() == SQLLogical.SubType.OR) {
                        boolean bl2 = status = rChild.isSameExpression(lChild.getChild(0), false) || rChild.isSameExpression(lChild.getChild(1), false);
                    }
                }
            }
        }
        if (!status) {
            this.traceNodeCondition(false, "Boolean algebra absorption laws can be applied.", trace);
        } else {
            this.traceNodeCondition(false, "Boolean algebra absorption laws cannot be applied.", trace);
        }
        return status;
    }
}

