/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.LinkedList;

public final class ApplyDeMorgansLaws
extends RQETransformation {
    public ApplyDeMorgansLaws() {
        this.mName = "Apply DeMorgan's Laws.";
        this.mPassNumbers = new int[]{8};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mTypes = new int[]{301027};
    }

    private IXQEQueryNode cleanupConsecutiveLogicalNOTs(IXQEQueryNode startingNode, Direction direction) {
        int consecutiveNOTCount = 1;
        IXQEQueryNode endingNode = startingNode;
        if (Direction.UP == direction) {
            while (301027 == endingNode.getParent().getType() && SQLLogical.SubType.NOT == ((SQLLogical)endingNode.getParent()).getSubType()) {
                ++consecutiveNOTCount;
                endingNode = endingNode.getParent();
            }
        } else {
            while (301027 == endingNode.getChild(0).getType() && SQLLogical.SubType.NOT == ((SQLLogical)endingNode.getChild(0)).getSubType()) {
                ++consecutiveNOTCount;
                endingNode = endingNode.getChild(0);
            }
        }
        if (consecutiveNOTCount == 1) {
            return endingNode;
        }
        if (consecutiveNOTCount % 2 == 0) {
            startingNode = Direction.UP == direction ? startingNode.getChild(0) : endingNode.getChild(0);
        } else if (Direction.DOWN == direction) {
            startingNode = endingNode;
        }
        for (int i = 0; i < consecutiveNOTCount; ++i) {
            startingNode.getParent().extract();
        }
        return startingNode;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        if (301027 != (node = this.cleanupConsecutiveLogicalNOTs(node, Direction.UP)).getType()) {
            return;
        }
        LinkedList<SQLLogical> logicalNOTsRemaining = new LinkedList<SQLLogical>();
        logicalNOTsRemaining.add((SQLLogical)node);
        LinkedList<SQLLogical> nonLogicalNOTsRemaining = new LinkedList<SQLLogical>();
        while (!logicalNOTsRemaining.isEmpty()) {
            SQLLogical currentNOT = (SQLLogical)logicalNOTsRemaining.removeFirst();
            IXQEQueryNode currentChild = currentNOT.getChild(0);
            if (currentChild.getType() == 301027) {
                SQLLogical.SubType operatorType = ((SQLLogical)currentChild).getSubType();
                if (operatorType == SQLLogical.SubType.AND || operatorType == SQLLogical.SubType.OR) {
                    SQLLogical logicalOperator = (SQLLogical)currentChild;
                    if (logicalOperator.getSubType() == SQLLogical.SubType.AND) {
                        logicalOperator.setSubType(SQLLogical.SubType.OR);
                    } else {
                        logicalOperator.setSubType(SQLLogical.SubType.AND);
                    }
                    XQENodeFactory nodeFactory = environment.getNodeFactory();
                    SQLLogical leftOperand = (SQLLogical)nodeFactory.createNode(301027);
                    leftOperand.setSubType(SQLLogical.SubType.NOT);
                    logicalOperator.getChild(0).insertParent(leftOperand);
                    SQLLogical rightOperand = (SQLLogical)nodeFactory.createNode(301027);
                    rightOperand.setSubType(SQLLogical.SubType.NOT);
                    logicalOperator.getChild(1).insertParent(rightOperand);
                    currentNOT.extract();
                    logicalOperator.invalidateSupportCache();
                    logicalNOTsRemaining.add(leftOperand);
                    logicalNOTsRemaining.add(rightOperand);
                    continue;
                }
                if (operatorType != SQLLogical.SubType.NOT || 301027 != (node = this.cleanupConsecutiveLogicalNOTs(currentNOT, Direction.DOWN)).getType() || SQLLogical.SubType.NOT != ((SQLLogical)node).getSubType()) continue;
                logicalNOTsRemaining.addFirst((SQLLogical)node);
                continue;
            }
            nonLogicalNOTsRemaining.add(currentNOT);
        }
        for (SQLLogical logicalNOT : nonLogicalNOTsRemaining) {
            IXQEQueryNode currentChild = logicalNOT.getChild(0);
            if (301026 != currentChild.getType()) continue;
            ((SQLComparison)currentChild).invertSubType();
            logicalNOT.extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = dataSource == null || !dataSource.isRelational() || dataSource.getCapabilities().isSupported("performance.transitiveClosure") || dataSource.getCapabilities().isSupported("performance.predicatePushdown") || !node.isSupported(dataSource);
        if (status) {
            SQLLogical.SubType operatorType;
            status = false;
            if (((SQLLogical)node).getSubType() == SQLLogical.SubType.NOT && (node = node.getChild(0)).getType() == 301027 && ((operatorType = ((SQLLogical)node).getSubType()) == SQLLogical.SubType.AND || operatorType == SQLLogical.SubType.OR)) {
                status = true;
            }
        }
        if (status) {
            this.traceNodeCondition(false, "DeMorgan's Laws can be applied.", trace);
        } else {
            this.traceNodeCondition(false, "DeMorgan's Laws cannot be applied.", trace);
        }
        return status;
    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

