/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ApplyDistributiveLaws
extends RQETransformation {
    private static final int CONJUNCT_THRESHOLD = 128;
    private static final int MAX_DEPTH = 8;

    public ApplyDistributiveLaws() {
        this.mName = "Apply boolean algebra distributive laws.";
        this.mPassNumbers = new int[]{9};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mTypes = new int[]{301027};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLFilter factor = (SQLFilter)node.getAncestorOfType(301009);
        SQLLogical predicate = (SQLLogical)node;
        IXQEQueryNode lChild = predicate.getChild(0);
        IXQEQueryNode rChild = predicate.getChild(1);
        if (lChild.getType() == 301027 && ((SQLLogical)lChild).getSubType() == SQLLogical.SubType.AND) {
            IXQEQueryNode cNode = rChild;
            IXQEQueryNode aNode = lChild.getChild(0);
            SQLLogical orNode = (SQLLogical)factory.createNode(301027);
            orNode.setSubType(SQLLogical.SubType.OR);
            aNode.move(orNode);
            cNode.insertParent(orNode);
            cNode = (SQLQueryNode)factory.deepCopyNode(cNode);
            lChild.addChild(cNode);
            ((SQLLogical)lChild).setSubType(SQLLogical.SubType.OR);
            predicate.setSubType(SQLLogical.SubType.AND);
            ((SQLQueryNode)lChild).invalidateSupportCache();
        } else {
            IXQEQueryNode aNode = lChild;
            IXQEQueryNode bNode = rChild.getChild(0);
            SQLLogical orNode = (SQLLogical)factory.createNode(301027);
            orNode.setSubType(SQLLogical.SubType.OR);
            aNode.insertParent(orNode);
            bNode.move(orNode);
            aNode = (SQLQueryNode)factory.deepCopyNode(aNode);
            rChild.addChild(aNode, 0);
            ((SQLLogical)rChild).setSubType(SQLLogical.SubType.OR);
            predicate.setSubType(SQLLogical.SubType.AND);
            ((SQLQueryNode)rChild).invalidateSupportCache();
        }
        factor.incrementNumberOfConjuncts();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        SQLFilter factor = (SQLFilter)node.getAncestorOfType(301009);
        boolean bl = status = factor != null && factor.getNumberOfConjuncts() < 128;
        if (status) {
            boolean bl2 = status = dataSource == null || !dataSource.isRelational() || dataSource.getCapabilities().isSupported("performance.transitiveClosure") || dataSource.getCapabilities().isSupported("performance.predicatePushdown") || !node.isSupported(dataSource);
        }
        if (status) {
            SQLLogical predicate = (SQLLogical)node;
            status = false;
            if (predicate.getSubType() == SQLLogical.SubType.OR) {
                IXQEQueryNode lChild = predicate.getChild(0);
                IXQEQueryNode rChild = predicate.getChild(1);
                boolean bl3 = status = (lChild.getType() == 301027 && ((SQLLogical)lChild).getSubType() == SQLLogical.SubType.AND || rChild.getType() == 301027 && ((SQLLogical)rChild).getSubType() == SQLLogical.SubType.AND) && this.getDepth(factor.getPredicate()) <= 8;
            }
        }
        if (!status) {
            this.traceNodeCondition(false, "Boolean algebra distributive law can be applied.", trace);
        } else {
            this.traceNodeCondition(false, "Boolean algebra distributive law cannot be applied.", trace);
        }
        return status;
    }

    private int getDepth(IXQEQueryNode node) {
        int depth = 1;
        if (node.getType() == 301027 && (((SQLLogical)node).getSubType() == SQLLogical.SubType.AND || ((SQLLogical)node).getSubType() == SQLLogical.SubType.OR)) {
            depth += Math.max(this.getDepth(node.getChild(0)), this.getDepth(node.getChild(1)));
        }
        return depth;
    }
}

