/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ApplyDoubleNegativeLaw
extends RQETransformation {
    public ApplyDoubleNegativeLaw() {
        this.mName = "Apply boolean algebra double negative laws.";
        this.mPassNumbers = new int[]{8, 10};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mTypes = new int[]{301027};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        node.getChild(0).extract();
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = dataSource == null || !dataSource.isRelational() || dataSource.getCapabilities().isSupported("performance.transitiveClosure") || dataSource.getCapabilities().isSupported("performance.predicatePushdown") || !node.isSupported(dataSource);
        if (status) {
            if (((SQLLogical)node).getSubType() != SQLLogical.SubType.NOT) {
                status = false;
            } else if ((node = node.getChild(0)).getType() != 301027 || ((SQLLogical)node).getSubType() != SQLLogical.SubType.NOT) {
                status = false;
            }
        }
        if (status) {
            this.traceNodeCondition(false, "Boolean algebra double negative laws can be applied.", trace);
        } else {
            this.traceNodeCondition(false, "Boolean algebra double negative laws cannot be applied.", trace);
        }
        return status;
    }
}

