/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class CollapseNoDataExpressions
extends RQETransformation {
    public CollapseNoDataExpressions() {
        this.mName = "Collapses parts of the execution tree that have constant false filters.";
        this.mPassNumbers = new int[]{18};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN;
        this.mTypes = new int[]{301009};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        pQueryBlock.getChild(0).detach();
        SQLTableFunction function = (SQLTableFunction)nodeFactory.createNode(301038);
        pQueryBlock.addChild(function);
        SQLQueryItemList qil = pQueryBlock.getQueryItemList();
        function.setSubType(SQLTableFunction.SubType.EMPTY);
        function.setDataType(SQLBinderUtil.makeRowTypeFromQueryItems(qil));
        RowsetInfo ri = new RowsetInfo();
        for (SQLQueryItem sqlQueryItem : qil) {
            ColumnInfo ci = new ColumnInfo(sqlQueryItem);
            ri.addColumnInfo(ci);
        }
        ObjectValue value = DataValueFactory.createObjectValue(ri);
        SQLLiteral literal = (SQLLiteral)nodeFactory.createNode(301031);
        literal.setDataType(DataTypeFactory.getObjectType());
        literal.setValue(value);
        function.addChild(literal);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLExpression predicate = ((SQLFilter)node).getPredicate();
        boolean status = predicate.isConstantValue() && predicate.isExecutable(true);
        status = status && ((SQLFilter)node).getPropertyValue("factorType") != null;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        status = status && !pQueryBlock.isForeign();
        int blockType = pQueryBlock.getBlockType();
        status = status && (blockType == 301015 || blockType == 301010);
        boolean bl = status = status && pQueryBlock.getQueryItemList() != null;
        if (status) {
            this.traceQueryCondition(status, "Filter is a known constant", trace);
        } else {
            this.traceQueryCondition(status, "Filter is not a known constant", trace);
        }
        return status;
    }
}

