/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLQuantifier;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertAnyPredicate
extends RQETransformation {
    public ConvertAnyPredicate() {
        this.mName = "Convert a '= ANY' predicate node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301055};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode inNode = factory.createNode(301076);
        node.getParent().exchange(inNode, true);
        inNode.getChild(1).extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLComparison comparison = (SQLComparison)node.getParent();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean status = false;
        if (comparison.getSubType() == SQLComparison.SubType.EQUAL) {
            boolean bl = status = node.getType() == 301055 && (((SQLQuantifier)node).getSubType() == SQLQuantifier.SubType.ANY || ((SQLQuantifier)node).getSubType() == SQLQuantifier.SubType.SOME);
        }
        if (dataSource != null && status) {
            boolean bl = status = !pQueryBlock.isSupported(dataSource);
        }
        if (status) {
            this.traceQueryCondition(status, "IN expression is not supported.", trace);
        } else {
            this.traceQueryCondition(status, "IN expression is supported.", trace);
        }
        return status;
    }
}

