/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.HashMap;
import java.util.Map;

public class ConvertDateTimeAndIntervalLiteralExpression
extends RQETransformation {
    private static final Map<IntervalQualifier, String> FUNCTION_NAMES = new HashMap<IntervalQualifier, String>();

    public ConvertDateTimeAndIntervalLiteralExpression() {
        this.mName = "convert date/time and interval literal to a predefined function";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301025};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryNode leftNode = (SQLQueryNode)node.getChild(0);
        if (leftNode.getDataType().getSubType() != DataSubType.DATETIMETYPE) {
            node.addChild(node.detachChild(0));
        }
        SQLLiteral literalNode = (SQLLiteral)node.getChild(1);
        int iValue = 0;
        SQLFunction functionNode = (SQLFunction)nodeFactory.createNode(301033);
        IntervalType intervalType = (IntervalType)literalNode.getDataType();
        switch (intervalType.getQualifier()) {
            case INTERVAL_YEAR: {
                iValue = ((IntervalYearMonthValue)literalNode.getValue()).getYear();
                functionNode.setSubType(SQLFunction.SubType.ADD_YEARS);
                break;
            }
            case INTERVAL_MONTH: {
                iValue = ((IntervalYearMonthValue)literalNode.getValue()).getMonth();
                functionNode.setSubType(SQLFunction.SubType.ADD_MONTHS);
                break;
            }
            case INTERVAL_DAY: {
                iValue = ((IntervalDayTimeValue)literalNode.getValue()).getDay();
                functionNode.setSubType(SQLFunction.SubType.ADD_DAYS);
                break;
            }
            case INTERVAL_HOUR: {
                iValue = ((IntervalDayTimeValue)literalNode.getValue()).getHour();
                functionNode.setSubType(SQLFunction.SubType.ADD_HOURS);
                break;
            }
            case INTERVAL_MINUTE: {
                iValue = ((IntervalDayTimeValue)literalNode.getValue()).getMinute();
                functionNode.setSubType(SQLFunction.SubType.ADD_MINUTES);
                break;
            }
            case INTERVAL_SECOND: {
                iValue = ((IntervalDayTimeValue)literalNode.getValue()).getSecond();
                functionNode.setSubType(SQLFunction.SubType.ADD_SECONDS);
                break;
            }
        }
        functionNode.setFunctionName(FUNCTION_NAMES.get((Object)intervalType.getQualifier()));
        IntervalValue intervalValue = (IntervalValue)literalNode.getValue();
        if (intervalValue.getSign() < 0) {
            iValue *= intervalValue.getSign();
        }
        if (((SQLValueExpression)node).getSubType() == SQLValueExpression.SubType.SUBTRACT) {
            iValue *= -1;
        }
        node.exchange(functionNode, true);
        IntegerValue integerValue = DataValueFactory.createIntegerValue(iValue);
        literalNode.setDataType(DataTypeFactory.getIntegerType());
        literalNode.setValue(integerValue);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLValueExpression sqlNode = (SQLValueExpression)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean status = false;
        if (dataSource != null && dataSource.isRelational()) {
            boolean bl = status = sqlNode.getSubType() == SQLValueExpression.SubType.ADD || sqlNode.getSubType() == SQLValueExpression.SubType.SUBTRACT;
            if (status) {
                SQLQueryNode leftNode = (SQLQueryNode)sqlNode.getChild(0);
                SQLQueryNode rightNode = (SQLQueryNode)sqlNode.getChild(1);
                if (leftNode.getDataType().getSubType() != DataSubType.DATETIMETYPE) {
                    leftNode = (SQLQueryNode)sqlNode.getChild(1);
                    rightNode = (SQLQueryNode)sqlNode.getChild(0);
                }
                boolean bl2 = status = leftNode.getDataType().getSubType() == DataSubType.DATETIMETYPE && rightNode.getType() == 301031 && (rightNode.getDataType().getSubType() == DataSubType.INTERVALYMTYPE || rightNode.getDataType().getSubType() == DataSubType.INTERVALDTTYPE);
                if (status) {
                    boolean bl3 = status = leftNode.isSupported(dataSource) && !sqlNode.isSupported(dataSource);
                }
                if (status) {
                    byte leftCCLType = leftNode.getDataType().getCCLTypeCode();
                    IntervalType intervalType = (IntervalType)rightNode.getDataType();
                    switch (intervalType.getQualifier()) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: {
                            status = leftCCLType != 58 && leftCCLType != 52;
                            break;
                        }
                        case INTERVAL_HOUR: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_SECOND: {
                            status = leftCCLType != 57;
                            break;
                        }
                        default: {
                            status = false;
                        }
                    }
                    if (status) {
                        IDataType[] fArguments = new IDataType[]{null, null};
                        fArguments[0] = leftNode.getDataType();
                        fArguments[1] = DataTypeFactory.getIntegerType();
                        IDataSourceCapabilities capabilities = pQueryBlock.getDataSource().getCapabilities();
                        status = SQLFunction.isFeatureSupported(capabilities, FUNCTION_NAMES.get((Object)intervalType.getQualifier()), fArguments);
                    }
                    if (status) {
                        boolean bl4 = status = !((SQLExpression)node).isExecutable(false);
                    }
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Expression needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "Expression does not need to be converted.", trace);
        }
        return status;
    }

    static {
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_YEAR, "AddYears");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_MONTH, "AddMonths");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_DAY, "AddDays");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_HOUR, "AddHours");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_MINUTE, "AddMinutes");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_SECOND, "AddSeconds");
    }
}

