/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertDateTimeAndIntervalToCompatibleSQL
extends RQETransformation {
    public ConvertDateTimeAndIntervalToCompatibleSQL() {
        this.mName = "convert date/time +/- interval to a SQL standard equivalent.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301025};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLCast castNode = (SQLCast)factory.createNode(301047);
        SQLDataType dType = (SQLDataType)factory.createNode(301037);
        SQLQueryNode leftNode = (SQLQueryNode)node.getChild(0);
        if (leftNode.getDataType().getSubType() != DataSubType.DATETIMETYPE) {
            node.addChild(node.detachChild(0));
        }
        SQLQueryNode rightNode = (SQLQueryNode)node.getChild(1);
        IntervalType intervalType = (IntervalType)rightNode.getDataType();
        int leadingPrecision = intervalType.getLeadingPrecision();
        intervalType = leftNode.getDataType().getCCLTypeCode() == 57 ? DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY) : DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_MINUTE_TO_SECOND);
        intervalType.setLeadingPrecision(leadingPrecision);
        dType.setDataType(intervalType);
        node.getChild(1).insertParent(castNode);
        castNode.addChild(dType);
        ((SQLQueryNode)node).invalidateSupportCache();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLValueExpression sqlNode = (SQLValueExpression)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean status = false;
        if (dataSource != null) {
            boolean bl = status = sqlNode.getSubType() == SQLValueExpression.SubType.ADD || sqlNode.getSubType() == SQLValueExpression.SubType.SUBTRACT;
            if (status) {
                byte leftCCLType;
                SQLQueryNode leftNode = (SQLQueryNode)sqlNode.getChild(0);
                SQLQueryNode rightNode = (SQLQueryNode)sqlNode.getChild(1);
                if (leftNode.getDataType().getSubType() != DataSubType.DATETIMETYPE) {
                    leftNode = (SQLQueryNode)sqlNode.getChild(1);
                    rightNode = (SQLQueryNode)sqlNode.getChild(0);
                }
                boolean bl2 = status = ((leftCCLType = leftNode.getDataType().getCCLTypeCode()) == 57 || leftCCLType == 58) && rightNode.getDataType().getSubType() == DataSubType.INTERVALDTTYPE;
                if (status) {
                    IntervalType intervalType = (IntervalType)rightNode.getDataType();
                    boolean isQualifierDAY = false;
                    boolean containsQualifierDAY = false;
                    switch (intervalType.getQualifier()) {
                        case INTERVAL_DAY: {
                            isQualifierDAY = true;
                        }
                        case INTERVAL_DAY_TO_HOUR: 
                        case INTERVAL_DAY_TO_MINUTE: 
                        case INTERVAL_DAY_TO_SECOND: {
                            containsQualifierDAY = true;
                        }
                    }
                    status = leftCCLType == 57 && !isQualifierDAY || leftCCLType == 58 && containsQualifierDAY;
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Expression needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "Expression does not need to be converted.", trace);
        }
        return status;
    }
}

