/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class ConvertFilterToConjunctiveNormalForm
extends RQETransformation {
    public ConvertFilterToConjunctiveNormalForm() {
        this.mName = "Convert filter to conjunction normal form and analyze each conjunct.";
        this.mPassNumbers = new int[]{12};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301009};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        List<SQLFilter> factorList = SQLPreoptimizerUtil.convertCnf(environment, pQueryBlock, node.getChild(0), node);
        for (SQLFilter factor : factorList) {
            FactorAnalyzer.analyze(factor);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = ((SQLFilter)node).getFactorType() == null;
        if (status) {
            SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
            IDataSource dataSource = pQueryBlock.getDataSource();
            boolean bl2 = status = dataSource == null || !dataSource.isRelational() || this.isRequiredForDatasource(dataSource) || !node.isSupported(dataSource);
        }
        if (status) {
            this.traceQueryCondition(status, "Filter node needs to be converted to conjunction normal form.", trace);
        } else {
            this.traceQueryCondition(status, "Filter node doesn't need to be converted to conjunction normal form.", trace);
        }
        return status;
    }

    private boolean isRequiredForDatasource(IDataSource dataSource) {
        return dataSource.getCapabilities().isSupported("performance.transitiveClosure") || dataSource.getCapabilities().isSupported("performance.predicatePushdown") || dataSource.getCapabilities().isSupported("supports.rewriteImplicitCrossJoins");
    }
}

