/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.preoptimization.GenerateCastOverExactNumericDivision;

public class ConvertRatioToReport
extends RQETransformation {
    public ConvertRatioToReport() {
        this.mName = "Convert RATIO_TO_REPORT aggregate.";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{301034};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLAggregate sqlNode = (SQLAggregate)nodeFactory.createNode(301034);
        sqlNode.setSubType(SQLAggregate.SubType.SUM);
        node.exchange(sqlNode, true);
        SQLValueExpression divNode = (SQLValueExpression)nodeFactory.createNode(301025);
        divNode.setSubType(SQLValueExpression.SubType.DIVIDE);
        sqlNode.insertParent(divNode);
        divNode.addChild(nodeFactory.deepCopyNode(sqlNode.getChild(0)), 0);
        if (GenerateCastOverExactNumericDivision.optionalCastIsNeeded(divNode)) {
            GenerateCastOverExactNumericDivision.doTransformation(divNode, environment);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLAggregate sqlNode = (SQLAggregate)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = pQueryBlock.isForeign() && sqlNode.getSubType() == SQLAggregate.SubType.RATIO_TO_REPORT && !SQLAggregate.isOlapFeatureSupported(pQueryBlock.getDataSource().getCapabilities(), SQLAggregate.SubType.RATIO_TO_REPORT, sqlNode.getNumberParameters());
        if (status) {
            this.traceQueryCondition(status, "RATIO_TO_REPORT aggregate needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "RATIO_TO_REPORT aggregate doesn't need to be converted.", trace);
        }
        return status;
    }
}

