/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSimpleCase;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWhen;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.CharValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.SmallintValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertSQLTertile
extends RQETransformation {
    private static final int NTILE_SECTIONS = 3;
    private static final int LOW_SECTION = 1;
    private static final int MED_SECTION = 2;

    public ConvertSQLTertile() {
        this.mName = "Convert TERTILE aggregate.";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{301034};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLAggregate aggr = (SQLAggregate)factory.createNode(301034);
        aggr.setSubType(SQLAggregate.SubType.NTILE);
        IXQEQueryNode[] children = node.getChildren();
        node.detachChildren();
        aggr.addChildren(children, 0);
        aggr.addChild(this.produceIntLiteral(factory, 3), 0);
        SQLSimpleCase caseExp = (SQLSimpleCase)factory.createNode(301073);
        aggr.insertParent(caseExp);
        SQLValueList vList = (SQLValueList)factory.createNode(301030);
        SQLWhen when = (SQLWhen)factory.createNode(301048);
        vList.addChild(when);
        when.addChild(this.produceIntLiteral(factory, 1));
        when.addChild(this.produceCharLiteral(factory, "H"));
        when = (SQLWhen)factory.createNode(301048);
        vList.addChild(when);
        when.addChild(this.produceIntLiteral(factory, 2));
        when.addChild(this.produceCharLiteral(factory, "M"));
        caseExp.addChild(vList);
        caseExp.addChild(this.produceCharLiteral(factory, "L"));
        node.exchange(caseExp);
    }

    private SQLLiteral produceIntLiteral(IXQENodeFactory factory, int intVal) {
        SmallintValue sValue = DataValueFactory.createSmallintValue();
        ((Value)sValue).set(intVal);
        SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
        literal.setValue(sValue);
        literal.setDataType(DataTypeFactory.getIntegerType());
        return literal;
    }

    private SQLLiteral produceCharLiteral(IXQENodeFactory factory, String charVal) {
        CharValue cValue = DataValueFactory.createCharValue();
        ((Value)cValue).set(charVal);
        SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
        literal.setValue(cValue);
        return literal;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLAggregate sqlNode = (SQLAggregate)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = pQueryBlock.isForeign() && sqlNode.getSubType() == SQLAggregate.SubType.TERTILE && !SQLAggregate.isOlapFeatureSupported(pQueryBlock.getDataSource().getCapabilities(), SQLAggregate.SubType.TERTILE, 0) && SQLAggregate.isOlapFeatureSupported(pQueryBlock.getDataSource().getCapabilities(), SQLAggregate.SubType.NTILE, 1) && SQLSimpleCase.isFeatureSupported(pQueryBlock.getDataSource().getCapabilities());
        if (status) {
            this.traceQueryCondition(status, "TERTILE aggregate needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "TERTILE aggregate doesn't need to be converted.", trace);
        }
        return status;
    }
}

