/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqe.transformation.relational.util.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateProjectionWithCompatibleWindowOrderings
extends RQETransformation {
    public CreateProjectionWithCompatibleWindowOrderings() {
        this.mName = "Create project node for aggregates that have compatible window orderings.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        SQLProject project = (SQLProject)node;
        SQLValueList vList1 = project.getOutputList();
        List<IXQEQueryNode> windows = vList1.getDescendantsOfTypeOrdered(301041, false);
        ArrayList<IXQEQueryNode> aggrList = new ArrayList<IXQEQueryNode>();
        Ordering ordering = SQLPreoptimizerUtil.getWindowOrdering((SQLWindow)windows.remove(0));
        for (IXQEQueryNode window : windows) {
            Ordering anotherOrdering = SQLPreoptimizerUtil.getWindowOrdering((SQLWindow)window);
            if (ordering.isCompatible(anotherOrdering)) {
                ordering.merge(anotherOrdering);
                continue;
            }
            aggrList.add((SQLQueryNode)window.getParent());
        }
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setDataSourceList(dataSources);
        IXQEQueryNode child = project.getChild(0);
        child.insertParent(qBlock);
        SQLProject pNode = (SQLProject)nodeFactory.createNode(301015);
        List<IXQEQueryNode> exprList = vList1.getProjectableExpressionsIncludingAnchorList(aggrList);
        SQLValueList vList2 = SQLPreoptimizerUtil.buildProjection(environment, exprList, 0, 0, qBlock.getDataSource());
        qBlock.getChild(0).insertParent(pNode);
        pNode.setCollapsible(false);
        pNode.addChild(vList2);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        if (qBlock == null || qBlock.isForeign()) {
            status = false;
        }
        if (status) {
            SQLProject project = (SQLProject)node;
            SQLValueList vList1 = project.getOutputList();
            List<IXQEQueryNode> windows = vList1.getDescendantsOfTypeOrdered(301041, false);
            boolean bl = status = windows.size() > 1;
            if (status) {
                status = false;
                Ordering ordering = SQLPreoptimizerUtil.getWindowOrdering((SQLWindow)windows.remove(0));
                for (IXQEQueryNode window : windows) {
                    Ordering anotherOrdering = SQLPreoptimizerUtil.getWindowOrdering((SQLWindow)window);
                    if (ordering.isCompatible(anotherOrdering)) {
                        ordering.merge(anotherOrdering);
                        continue;
                    }
                    status = true;
                    break;
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Projection has incompatible window orderings between aggregates", trace);
        } else {
            this.traceQueryCondition(status, "Projection does not have incompatible window orderings between aggregates", trace);
        }
        return status;
    }
}

