/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CreateSemiJoinWithExistsPredicate
extends RQETransformation {
    public CreateSemiJoinWithExistsPredicate() {
        this.mName = "Create a semi-join query.";
        this.mPassNumbers = new int[]{3};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301014};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        IXQEQueryNode parent = node.getParent();
        while (parent.getType() == 301009) {
            factorList.add(0, (SQLFilter)parent);
            parent = parent.getParent();
        }
        IXQEQueryNode filterNode = nodeFactory.createNode(301009);
        node.insertParent(filterNode);
        IXQEQueryNode existsNode = nodeFactory.createNode(301054);
        filterNode.addChild(existsNode);
        SQLQueryBlock qBlock2 = (SQLQueryBlock)nodeFactory.createNode(301004);
        existsNode.addChild(qBlock2);
        SQLQueryNode child = (SQLQueryNode)node.getChild(1).detach();
        qBlock2.setDataSource(child.getDataSource());
        IXQEQueryNode projNode = nodeFactory.createNode(301015);
        qBlock2.addChild(projNode);
        projNode.addChild(child);
        node.extract();
        Iterator fIterator = factorList.iterator();
        while (fIterator.hasNext()) {
            SQLFilter factor = (SQLFilter)fIterator.next();
            BitMask fIncidence = factor.getIncidence();
            if (fIncidence.cardinality() == 1 && !fIncidence.get(1)) continue;
            IXQEQueryNode predicate = factor.getPredicate().detach();
            projNode.getChild(0).insertParent(factor.extract());
            factor.addChild(predicate);
            fIterator.remove();
            if (fIncidence.cardinality() <= 1) continue;
            BitMask mask = new BitMask();
            mask.set(0);
            List<SQLFid> fidList = factor.getPredicate().getFieldIdentifiers(null, mask);
            for (SQLFid fid : fidList) {
                SQLParameter parameter = (SQLParameter)nodeFactory.createNode(301051);
                fid.exchange(parameter);
            }
        }
        IXQEQueryNode valueList = nodeFactory.createNode(301030);
        projNode.addChild(valueList);
        SQLLiteral literal = (SQLLiteral)nodeFactory.createNode(301031);
        literal.setValue(DataValueFactory.createIntegerValue(0));
        valueList.addChild(literal);
        qBlock.getParent().extract();
        qBlock.getParent().extract();
        qBlock2.setForeign(projNode.isSupported(qBlock2.getDataSource()));
        qBlock.setBlockType(301016);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        this.traceQueryCondition(false, "A semi-join query cannot be created.", trace);
        return false;
    }
}

