/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class DecomposeSQLFilter
extends RQETransformation {
    public DecomposeSQLFilter() {
        this.mName = "Decompose a SQLFilter node.";
        this.mPassNumbers = new int[]{12, 18};
        this.mTypes = new int[]{301009};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        pQueryBlock.setForeign(false);
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        IDataSource dataSource = pQueryBlock.getDataSource();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode baseNode = node.getChild(0);
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setForeign(true);
        qBlock.setDataSourceList(dataSources);
        baseNode.insertParent(qBlock);
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        IXQEQueryNode parent = node;
        while (parent.getType() == 301009) {
            factorList.add(0, (SQLFilter)parent);
            parent = parent.getParent();
        }
        ArrayList<SQLXid> xidList = new ArrayList<SQLXid>();
        for (SQLFilter factor : factorList) {
            SQLExpression predicate = factor.getPredicate();
            if (predicate.isSupported(dataSource)) {
                IXQEQueryNode filter = nodeFactory.createNode(301009);
                baseNode.insertParent(filter);
                baseNode = filter;
                predicate.move(filter);
                factor.extract();
                continue;
            }
            xidList.addAll(CollectionCast.downcast(predicate.getDescendantsOfTypeOrdered(301082, false), IXQEQueryNode.class, SQLXid.class));
        }
        SQLQueryItemList queryItems = ((SQLQueryNode)baseNode).getQueryItemList();
        if (xidList.size() > 0) {
            Iterator it = xidList.iterator();
            while (it.hasNext()) {
                SQLXid xid = (SQLXid)it.next();
                if (queryItems.getQueryItem(xid) != null) continue;
                it.remove();
            }
        }
        List<IXQEQueryNode> excludeList = pQueryBlock.getDescendantsOfTypeOrdered(301034, false);
        List<IXQEQueryNode> eNodeList = pQueryBlock.getProjectableExpressionsExcludingAnchorList(dataSource, excludeList);
        SQLValueList vList = SQLPreoptimizerUtil.buildProjection(environment, eNodeList, null, 0, 0, dataSource, xidList);
        qBlock.setQueryItemList(SQLPreoptimizerUtil.getQueryItemList(queryItems, vList));
        SQLProject pNode = (SQLProject)nodeFactory.createNode(301015);
        qBlock.getChild(0).insertParent(pNode);
        pNode.addChild(vList);
        qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setForeign(false);
        qBlock.setDataSourceList(dataSources);
        parent.getChild(0).insertParent(qBlock);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        IXQEQueryNode dfSubTree = node.getChild(0);
        LinkedList<String> list = new LinkedList<String>();
        boolean bl = status = dataSource != null && pQueryBlock.getBlockType() != 301009 && dataSource.isRelational() && ((SQLFilter)node).getFactorType() != null && (dfSubTree.getType() != 301004 || ((SQLQueryBlock)dfSubTree).isForeign() && ((SQLQueryBlock)dfSubTree).getName() != null) && ((SQLQueryNode)node.getChild(0)).isSupported(dataSource, list) && !((SQLQueryNode)node.getChild(1)).isSupported(dataSource, list);
        if (status) {
            this.traceQueryCondition(status, "Filter condition is not supported." + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            this.traceQueryCondition(status, "Filter condition is supported.", trace);
        }
        return status;
    }
}

