/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DecomposeSQLGroupByWithNestedWindowedAggregates
extends RQETransformation {
    static final String DERIVED_TABLE_NAME = "D1";

    public DecomposeSQLGroupByWithNestedWindowedAggregates() {
        this.mName = "Decompose Nested Window Aggregate In Groupby.";
        this.mPassNumbers = new int[]{13};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock parentQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLValueList projectionList = (SQLValueList)node.getChild(1);
        List<SQLAggregate> nestedWindowAggregates = this.findWindowAggregatesWithNesting(projectionList);
        SQLValueList originalValueListNode = ((SQLQueryNode)node).getOutputList();
        SQLQueryBlock newQBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        newQBlock.setDataSourceList(parentQueryBlock.getDataSourceList());
        newQBlock.setName(DERIVED_TABLE_NAME);
        newQBlock.setForeign(true);
        node.insertParent(newQBlock);
        ArrayList<IXQEQueryNode> excludeList = new ArrayList<IXQEQueryNode>();
        excludeList.addAll(nestedWindowAggregates);
        List<IXQEQueryNode> projectableItems = projectionList.getProjectableExpressionsExcludingAnchorList(excludeList, environment);
        SQLValueList newProjection = SQLPreoptimizerUtil.buildProjection(environment, projectableItems, 0, 0, parentQueryBlock.getDataSource());
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        for (int i = 0; i < newProjection.getNumberChildren(); ++i) {
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName("C" + i);
            aliasList.add(aliasNode);
        }
        newProjection.setAliasList(aliasList);
        SQLQueryItemList queryItems = new SQLQueryItemList();
        List<IXQEQueryNode> fids = originalValueListNode.getDescendantsOfTypeOrdered(301032, false);
        for (int i = 0; i < fids.size(); ++i) {
            SQLFid fid = (SQLFid)fids.get(i);
            fid.setName(((SQLAlias)aliasList.get(fid.getColumnNo())).getName());
            fid.setTableName(DERIVED_TABLE_NAME);
            SQLQueryItem qItem = new SQLQueryItem(fid.getName(), fid.getDataType(), fid.getColumnNo());
            qItem.setTableName(DERIVED_TABLE_NAME);
            qItem.setSourceNo(0);
            queryItems.add(qItem);
        }
        newQBlock.setDerivedColumnList(null);
        newQBlock.setQueryItemList(queryItems);
        SQLProject newProjectNode = (SQLProject)nodeFactory.createNode(301015);
        newQBlock.insertParent(newProjectNode);
        newProjectNode.setCollapsible(false);
        node.addChild(newProjection, 1);
        originalValueListNode.move(newProjectNode);
    }

    private List<SQLAggregate> findWindowAggregatesWithNesting(SQLValueList list) {
        ArrayList<SQLAggregate> nestedWindowAggs = new ArrayList<SQLAggregate>();
        List<IXQEQueryNode> aggrs = list.getFirstDescendantsOfTypeOrdered(301034, false);
        block0: for (IXQEQueryNode aggr : aggrs) {
            if (!((SQLAggregate)aggr).isWindowedAggregate()) continue;
            List<IXQEQueryNode> childAggrs = aggr.getDescendantsOfTypeOrdered(301034, false);
            for (IXQEQueryNode childAggr : childAggrs) {
                if (!((SQLAggregate)childAggr).isWindowedAggregate()) continue;
                nestedWindowAggs.add((SQLAggregate)aggr);
                continue block0;
            }
        }
        return nestedWindowAggs;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        SQLValueList vList = (SQLValueList)node.getChild(1);
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        status = node.getChild(0).getType() != 301053 && !this.findWindowAggregatesWithNesting(vList).isEmpty();
        LinkedList<String> list = new LinkedList<String>();
        if (status && dataSource != null && dataSource.isRelational()) {
            boolean bl = status = !qBlock.isSupported(dataSource, list);
        }
        if (status) {
            super.traceQueryCondition(status, "Nested windows in Groupby has to be decomposed." + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            super.traceQueryCondition(status, "Groupby does not contain a nested window aggregate.", trace);
        }
        return status;
    }
}

