/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLHaving;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class DecomposeSQLHaving
extends RQETransformation {
    private static final String TABLE_NAME = "T_$0";
    private static final String COLUMN_NAME_PATTERN = "C_$%d";

    public DecomposeSQLHaving() {
        this.mName = "Decompose a HAVING clause of a SQLGroupBy node.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLGroupBy groupNode = (SQLGroupBy)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getParent();
        IDataSource dataSource = pQueryBlock.getDataSource();
        SQLValueList vList = groupNode.getOutputList();
        SQLHaving havingClause = groupNode.getHavingClause();
        SQLQueryNode predicate = havingClause.getPredicate();
        SQLFilter filterNode = (SQLFilter)nodeFactory.createNode(301009);
        node.insertParent(filterNode);
        predicate.move(filterNode);
        havingClause.extract();
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setForeign(true);
        qBlock.setDataSourceList(pQueryBlock.getDataSourceList());
        qBlock.setName(TABLE_NAME);
        node.insertParent(qBlock);
        int nFields = vList.getNumberChildren();
        List<SQLFid> predicateFids = predicate.getFieldIdentifiers(new int[]{301034, 301004});
        List<SQLAlias> aliasList = vList.getAliasList();
        if (aliasList == null) {
            aliasList = new ArrayList<SQLAlias>();
            vList.setAliasList(aliasList);
        }
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            if (i < aliasList.size() && aliasList.get(i) != null) continue;
            String name = null;
            IXQEQueryNode exprNode = vList.getChild(i);
            name = exprNode.getType() == 301032 ? ((SQLFid)exprNode).getName() : String.format(COLUMN_NAME_PATTERN, i);
            SQLAlias alias = (SQLAlias)nodeFactory.createNode(301028);
            alias.setName(name);
            if (i < aliasList.size()) {
                aliasList.set(i, alias);
                continue;
            }
            aliasList.add(alias);
        }
        IXQEQueryNode[] aggrNodes = predicate.getDescendantsOfType(301034, false, 301004);
        for (int i = 0; i < aggrNodes.length; ++i) {
            SQLAggregate aggrNode = (SQLAggregate)aggrNodes[i];
            SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
            int columnNo = vList.indexOf(aggrNode);
            aggrNode.exchange(fid);
            SQLAlias alias = null;
            if (columnNo < 0) {
                columnNo = vList.getNumberChildren();
                vList.addChild(aggrNode);
            } else {
                alias = aliasList.get(columnNo);
            }
            if (alias == null) {
                alias = (SQLAlias)nodeFactory.createNode(301028);
                alias.setName(String.format(COLUMN_NAME_PATTERN, columnNo));
                if (columnNo < aliasList.size()) {
                    aliasList.set(columnNo, alias);
                } else {
                    aliasList.add(alias);
                }
            }
            fid.setContextNo(0);
            fid.setSourceNo(0);
            fid.setColumnNo(columnNo);
            fid.setVirtualColumnNo(columnNo);
            fid.setDataType(aggrNode.getDataType());
            fid.setTableName(TABLE_NAME);
            fid.setName(alias.getName());
        }
        for (SQLFid fid : predicateFids) {
            int index = vList.indexOf(fid);
            if (index < 0) {
                index = vList.getNumberChildren();
                vList.addChild(nodeFactory.copyNode(fid));
                SQLAlias alias = (SQLAlias)nodeFactory.createNode(301028);
                alias.setName(String.format(COLUMN_NAME_PATTERN, index));
                aliasList.add(alias);
            }
            fid.setVirtualColumnNo(index);
            fid.setColumnNo(index);
            fid.setName(vList.getAlias(index));
            fid.setTableName(TABLE_NAME);
        }
        boolean supportedQuery = dataSource != null && groupNode.isSupported(dataSource) && predicate.isSupported(dataSource);
        pQueryBlock.setForeign(supportedQuery);
        if (nFields < vList.getNumberChildren() || supportedQuery) {
            SQLProject projectNode = (SQLProject)nodeFactory.createNode(301015);
            if (!supportedQuery) {
                qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
                qBlock.setForeign(false);
                qBlock.setDataSourceList(pQueryBlock.getDataSourceList());
                filterNode.insertParent(qBlock);
                qBlock.insertParent(projectNode);
            } else {
                filterNode.insertParent(projectNode);
            }
            SQLValueList vList2 = (SQLValueList)nodeFactory.createNode(301030);
            projectNode.addChild(vList2);
            for (int i = 0; i < nFields; ++i) {
                SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
                fid.setContextNo(0);
                fid.setSourceNo(0);
                fid.setColumnNo(i);
                fid.setVirtualColumnNo(i);
                fid.setDataType(((SQLQueryNode)vList.getChild(i)).getDataType());
                fid.setTableName(TABLE_NAME);
                fid.setName(vList.getAlias(i));
                vList2.addChild(fid);
            }
        }
        IXQEQueryNode parent = pQueryBlock.getParent();
        if (supportedQuery && parent.getType() == 301019) {
            SQLSortKeyList sortKeyList = ((SQLSort)parent).getSortKeyList();
            List<SQLFid> fids = CollectionCast.downcast(sortKeyList.getDescendantsOfTypeOrdered(301032, false, 301004), IXQEQueryNode.class, SQLFid.class);
            for (SQLFid fid : fids) {
                fid.setName(vList.getAlias(fid.getColumnNo()));
                fid.setTableName(null);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        SQLHaving havingClause = ((SQLGroupBy)node).getHavingClause();
        LinkedList<String> list = new LinkedList<String>();
        boolean bl = status = dataSource != null && havingClause != null && !((SQLQueryNode)node).hasWindowedAggregates();
        if (status) {
            boolean bl2 = status = !((SQLQueryNode)node).isSupported(dataSource, list) || dataSource.getCapabilities().isSupported("performance.convertHavingToWhere");
        }
        if (status) {
            this.traceQueryCondition(status, "Having clause of group by operator is not supported." + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            this.traceQueryCondition(status, "Having clause of group by operator is supported.", trace);
        }
        return status;
    }
}

