/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class DecomposeSQLJoin
extends RQETransformation {
    public DecomposeSQLJoin() {
        this.mName = "Decompose a SQLJoin node.";
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mPassNumbers = new int[]{19};
        this.mTypes = new int[]{301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLJoin jNode = (SQLJoin)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLFilter fNode = null;
        fNode = (SQLFilter)nodeFactory.createNode(301009);
        jNode.insertParent(fNode);
        jNode.getPredicate().move(fNode);
        List<SQLFilter> factorList = SQLPreoptimizerUtil.convertCnf(environment, pQueryBlock, node, fNode);
        for (SQLFilter factor : factorList) {
            FactorAnalyzer.analyze(factor, 301011);
        }
        factorList = new ArrayList<SQLFilter>();
        IXQEQueryNode parent = node.getParent();
        while (parent.getType() == 301009) {
            factorList.add(0, (SQLFilter)parent);
            parent = parent.getParent();
        }
        int[] nColumns = new int[2];
        boolean isConvertible = this.isConvertibleFOJ(node);
        for (int i = 0; i < 2; ++i) {
            SQLQueryNode child = (SQLQueryNode)node.getChild(i);
            if (child.getType() == 301016 && child.isSupported(null) || child.getType() == 301011 || child.getType() == 301004 && child.isSupported(child.getDataSource()) || isConvertible) {
                child = this.buildDerivedTable(environment, jNode, child, pQueryBlock, factorList, i);
                if (isConvertible) {
                    ((SQLQueryBlock)child).setForeign(child.isSupported(child.getDataSource()));
                }
            }
            nColumns[i] = child.getNumberColumns();
            if (i <= 0) continue;
            int n = i;
            nColumns[n] = nColumns[n] + nColumns[i - 1];
        }
        List<SQLFid> fidList = CollectionCast.downcast(pQueryBlock.getDescendantsOfTypeOrdered(301032, node), IXQEQueryNode.class, SQLFid.class);
        for (SQLFid fid : fidList) {
            int sourceNo = fid.getSourceNo();
            if (sourceNo != 1) continue;
            fid.setVirtualColumnNo(nColumns[sourceNo - 1] + fid.getColumnNo());
        }
        if (isConvertible) {
            for (SQLFilter factor : factorList) {
                if (factor.incidence().cardinality() <= 1) continue;
                FactorAnalyzer.analyze(factor, factor.getSubType());
            }
        }
        pQueryBlock.setForeign(false);
        pQueryBlock.setBlockType(301011);
        pQueryBlock.setFactorList(factorList);
        pQueryBlock.setMap(node.getChildren());
    }

    private boolean isConvertibleFOJ(IXQEQueryNode node) {
        boolean status = false;
        SQLJoin join = (SQLJoin)node;
        boolean bl = status = join.getJoinType() == SQLJoin.SubType.FULL_OUTER;
        if (status) {
            status = false;
            IXQEQueryNode temp = join;
            while (temp.getParent().getType() == 301009) {
                SQLFilter filter = (SQLFilter)(temp = temp.getParent());
                if (filter.incidence().cardinality() <= 1 || filter.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) continue;
                if (this.isConvertiblePredicate(filter.getPredicate())) {
                    status = true;
                    continue;
                }
                status = false;
                break;
            }
        }
        return status;
    }

    private boolean isConvertiblePredicate(SQLExpression predicate) {
        SQLAbstractBooleanFunction comparison;
        int pType = predicate.getType();
        if (pType == 301026 ? ((SQLComparison)(comparison = (SQLComparison)predicate)).getSubType() != SQLComparison.SubType.EQUAL : pType == 301075 && !((SQLIsDistinctFrom)(comparison = (SQLIsDistinctFrom)predicate)).isNegated()) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            SQLQueryNode expression = (SQLQueryNode)predicate.getChild(i);
            BitMask b = expression.incidence();
            if (b.cardinality() <= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IXQEQueryNode parent = node.getParent();
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        IDataSource dataSource = pQueryBlock.getDataSource();
        LinkedList<String> list = new LinkedList<String>();
        boolean bl = status = parent.getType() != 301014 && parent.getType() != 301011 && pQueryBlock.getBlockType() != 301011 && (dataSource == null || dataSources.size() > 1 || !((SQLQueryNode)node).isSupported(dataSource, list)) && ((SQLJoin)node).getPredicate() != null;
        if (status) {
            if (list.size() == 0) {
                if (dataSources.size() > 1) {
                    list.add("The join spans multiple databases.");
                } else if (dataSource == null) {
                    list.add("The join has non-relational argument.");
                }
            }
            this.traceQueryCondition(status, "Join node has to be decomposed. " + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            this.traceQueryCondition(status, "Join node doesn't have to be decomposed.", trace);
        }
        return status;
    }

    private SQLQueryBlock buildDerivedTable(IPlanningEnvironment environment, SQLJoin jNode, SQLQueryNode child, SQLQueryBlock pQueryBlock, List<SQLFilter> factorList, int sourceNo) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ArrayList<IDataSource> dsList = new ArrayList<IDataSource>();
        child.getDataSourceList(environment.getExecutionEnvironment().getDataSources(), dsList);
        IDataSource dataSource = dsList.get(0);
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setDataSourceList(dsList);
        qBlock.setForeign(true);
        child.insertParent(qBlock);
        SQLJoin.SubType jType = jNode.getJoinType();
        Iterator<SQLFilter> fIterator = factorList.iterator();
        while (fIterator.hasNext()) {
            boolean eligible;
            SQLFilter factor = fIterator.next();
            BitMask mask = factor.getIncidence();
            if (mask.cardinality() != 1 || !mask.get(sourceNo)) continue;
            boolean bl = eligible = factor.getSubType() == 301011;
            SQLExpression predicate = factor.getPredicate();
            if (!predicate.isSupported(dataSource) || jType == SQLJoin.SubType.LEFT_OUTER && (sourceNo == 0 && eligible || sourceNo == 1 && !eligible) || jType == SQLJoin.SubType.RIGHT_OUTER && (sourceNo == 1 && eligible || sourceNo == 0 && !eligible) || jType == SQLJoin.SubType.FULL_OUTER) continue;
            predicate.detach();
            qBlock.getChild(0).insertParent(factor.extract());
            factor.addChild(predicate);
            if (child.getType() == 301011) {
                SQLPreoptimizerUtil.fixFieldIdentifiers(predicate.getFieldIdentifiers(), child.getQueryItemList());
            }
            FactorAnalyzer.analyze(factor);
            fIterator.remove();
        }
        BitMask mask = new BitMask();
        mask.set(sourceNo);
        List<IXQEQueryNode> excludeList = pQueryBlock.getDescendantsOfTypeOrdered(301034, false);
        if (this.processNullConsumersAfterJoin(environment, pQueryBlock.getGovernors()) && (jType == SQLJoin.SubType.LEFT_OUTER && sourceNo == 1 || jType == SQLJoin.SubType.RIGHT_OUTER && sourceNo == 0 || jType == SQLJoin.SubType.FULL_OUTER)) {
            excludeList.addAll(pQueryBlock.getDescendantsOfTypesOrdered(new int[]{301072, 301024}, false));
        }
        List<IXQEQueryNode> eNodeList = pQueryBlock.getProjectableExpressions(dataSource, jType, sourceNo, excludeList, qBlock.getParent(), mask);
        SQLValueList vList = SQLPreoptimizerUtil.buildProjection(environment, eNodeList, null, sourceNo, 0, dataSource, pQueryBlock.getXidList());
        List<SQLFid> fids = vList.getFieldIdentifiers();
        for (IXQEQueryNode iXQEQueryNode : fids) {
            SQLFid fid = (SQLFid)iXQEQueryNode;
            fid.setVirtualColumnNo(fid.getColumnNo());
        }
        SQLProject pNode = (SQLProject)nodeFactory.createNode(301015);
        qBlock.getChild(0).insertParent(pNode);
        qBlock.setNumberColumns(vList.getNumberChildren());
        pNode.addChild(vList);
        if (child.getType() == 301011) {
            SQLPreoptimizerUtil.fixFieldIdentifiers(vList.getFieldIdentifiers(), child.getQueryItemList());
        }
        return qBlock;
    }

    private boolean processNullConsumersAfterJoin(IPlanningEnvironment environment, Governors governors) {
        if (governors != null && governors.getProcessNullConsumersAfterJoin() != null) {
            return governors.getProcessNullConsumersAfterJoin();
        }
        return environment.getMultiRequestContext().fetchBooleanConfiguration("queryPlanning.processNullConsumersAfterJoin[@enabled]", true);
    }
}

