/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLCall;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.LinkedList;

public final class DecomposeSQLQueryBlock
extends RQETransformation {
    public DecomposeSQLQueryBlock() {
        this.mName = "DecomposeSQLQueryBlock.";
        this.mPassNumbers = new int[]{14};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        ((SQLQueryBlock)node).setForeign(false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        IDataSource dataSource = qBlock.getDataSource();
        LinkedList<String> list = new LinkedList<String>();
        if (!qBlock.isForeign()) {
            status = false;
        } else if (qBlock.getBlockType() == 301061) {
            boolean bl = status = !((SQLCall)qBlock.getChild(0)).isDatabaseStoredProcedure();
            if (status) {
                list.add("This is not a database stored procedure.");
            }
        } else if (qBlock.getBlockType() == 301012 || qBlock.getBlockType() == 301091) {
            status = false;
        } else if (dataSource == null || !dataSource.isRelational() || dataSource.getMetadataProperties().get("isDummy") != null) {
            status = true;
        } else if (qBlock.isDerivedTable()) {
            status = !qBlock.getChild(0).isSupported(dataSource);
        } else {
            if (qBlock.getReusableQuery() != null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Query block is a cursor " + qBlock.getReusableQuery().toString() + ", but not a derived table.");
            }
            boolean bl = status = !((SQLQueryBlock)node).isSupported(dataSource, list);
        }
        if (status) {
            this.traceQueryCondition(status, "Query block is not supported. " + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            this.traceQueryCondition(status, "Query block is supported.", trace);
        }
        return status;
    }
}

