/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.List;

public final class DecomposeSQLSortAliasInOrderByExpression
extends RQETransformation {
    protected static final String DECOMPOSE_SQL_SORT_APPLIED = "DecomposeSQLSortAliasInOrderByExpressionApplied";

    public DecomposeSQLSortAliasInOrderByExpression() {
        this.mName = "Decompose a SQLSort node.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301019};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode child = node.getChild(0);
        if ((child = child.getChild(0)).getType() == 301022) {
            child = child.getChild(child.getNumberChildren() - 1);
        }
        while (child.getType() != 301015 && child.getType() != 301010) {
            child = child.getChild(0);
        }
        SQLProject projection = (SQLProject)child;
        SQLValueList vList = projection.getOutputList();
        List<SQLAlias> aliasList = vList.getAliasList();
        SQLSortKeyList sortKeyList = ((SQLSort)node).getSortKeyList();
        for (int i = 0; i < sortKeyList.getNumberChildren(); ++i) {
            IXQEQueryNode[] fids;
            SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
            IXQEQueryNode sortKeyExpr = sortKey.getChild(0);
            if (sortKeyExpr.getType() == 301032) continue;
            for (IXQEQueryNode fid : fids = sortKeyExpr.getDescendantsOfType(301032, false)) {
                SQLFid sqlFid = (SQLFid)fid;
                String alias = null;
                String name = null;
                String tname = null;
                name = sqlFid.getName();
                tname = sqlFid.getTableName();
                if (tname != null) continue;
                for (int j = 0; j < aliasList.size(); ++j) {
                    SQLAlias sqlAlias = aliasList.get(j);
                    if (sqlAlias != null) {
                        alias = sqlAlias.getName();
                    }
                    if (alias == null || name == null || !name.equals(alias)) continue;
                    IXQEQueryNode exprNode = vList.getChild(sqlFid.getVirtualColumnNo());
                    IXQEQueryNode copied = nodeFactory.deepCopyNode(exprNode);
                    fid.exchange(copied);
                }
            }
        }
        node.setPropertyValue(DECOMPOSE_SQL_SORT_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        if (node.getPropertyValue(DECOMPOSE_SQL_SORT_APPLIED) == Boolean.TRUE) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean status = false;
        boolean supportsAliasInOrderByExpression = dataSource != null && dataSource.getCapabilities().isSupported("supports.aliasInOrderByExpression");
        boolean supportsExpressionsInOrderBy = dataSource != null && dataSource.getCapabilities().isSupported("supports.expressionsInOrderBy");
        IXQEQueryNode child = node.getChild(0);
        if ((child = child.getChild(0)).getType() == 301022) {
            child = child.getChild(child.getNumberChildren() - 1);
        }
        while (child.getType() != 301015 && child.getType() != 301010) {
            child = child.getChild(0);
        }
        SQLProject projection = (SQLProject)child;
        SQLValueList vList = projection.getOutputList();
        List<SQLAlias> aliasList = vList.getAliasList();
        if (aliasList == null) {
            return false;
        }
        Boolean aliasInOrderByExpression = false;
        Boolean expressionInOrderBy = false;
        SQLSortKeyList sortKeyList = ((SQLSort)node).getSortKeyList();
        for (int i = 0; i < sortKeyList.getNumberChildren(); ++i) {
            IXQEQueryNode[] fids;
            SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
            IXQEQueryNode sortKeyExpr = sortKey.getChild(0);
            if (sortKeyExpr.getType() == 301032) continue;
            for (IXQEQueryNode fid : fids = sortKeyExpr.getDescendantsOfType(301032, false)) {
                SQLFid sqlFid = (SQLFid)fid;
                String alias = null;
                String name = null;
                String tname = null;
                name = sqlFid.getName();
                tname = sqlFid.getTableName();
                if (tname != null) {
                    expressionInOrderBy = true;
                    continue;
                }
                for (int j = 0; j < aliasList.size(); ++j) {
                    SQLAlias sqlAlias = aliasList.get(j);
                    if (sqlAlias != null) {
                        alias = sqlAlias.getName();
                    }
                    if (name == null || alias == null || !name.equals(alias)) continue;
                    aliasInOrderByExpression = true;
                }
            }
        }
        if (aliasInOrderByExpression.booleanValue() && (!supportsAliasInOrderByExpression || expressionInOrderBy.booleanValue() && !supportsExpressionsInOrderBy)) {
            status = true;
        }
        if (status) {
            this.traceQueryCondition(status, "Alias in order By expression is not supported.", trace);
        } else {
            this.traceQueryCondition(status, "Alias in order by expression is supported.", trace);
        }
        return status;
    }
}

