/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.bibushandler.datasource.DataSourceCapabilities;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EliminateExpressionFromAggregateWindow
extends RQETransformation {
    static final String DERIVED_TABLE_NAME = "D1";

    public EliminateExpressionFromAggregateWindow() {
        this.mName = "Eliminate Expressions from aggregate window.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{301015, 301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLGroupByList groupByList;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        SQLProject project = (SQLProject)node;
        SQLValueList projection = project.getOutputList();
        List<IXQEQueryNode> windows = projection.getDescendantsOfTypeOrdered(301041, false);
        this.eliminateConstantExpressionFromWindows(windows);
        List<IXQEQueryNode> exprList = this.getExpressions(windows);
        if (exprList.size() == 0) {
            return;
        }
        SQLQueryBlock newBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        newBlock.setDataSourceList(dataSources);
        project.getChild(0).insertParent(newBlock);
        SQLProject newProject = (SQLProject)nodeFactory.createNode(301015);
        newBlock.getChild(0).insertParent(newProject);
        List<IXQEQueryNode> derivedExpr = projection.getProjectableExpressionsIncludingAnchorList(exprList);
        if (node.getType() == 301010 && (groupByList = ((SQLGroupBy)node).getGroupByList()) != null) {
            derivedExpr.addAll(groupByList.getProjectableExpressions());
        }
        SQLValueList newProjection = SQLPreoptimizerUtil.buildProjection(environment, derivedExpr, 0, 0, pQueryBlock.getDataSource());
        newProject.addChild(newProjection);
        if (pQueryBlock.isForeign()) {
            SQLFid fid;
            int i;
            newBlock.setName(DERIVED_TABLE_NAME);
            newBlock.setForeign(true);
            ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
            for (int i2 = 0; i2 < newProjection.getNumberChildren(); ++i2) {
                SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
                aliasNode.setName("C" + i2);
                aliasList.add(aliasNode);
            }
            newProjection.setAliasList(aliasList);
            List<SQLAlias> outerAliasList = projection.getAliasList();
            if (outerAliasList == null) {
                outerAliasList = new ArrayList<SQLAlias>(projection.getNumberChildren());
                projection.setAliasList(outerAliasList);
            }
            for (int i3 = 0; i3 < projection.getNumberChildren(); ++i3) {
                SQLAlias aliasNode;
                IXQEQueryNode child = projection.getChild(i3);
                if (child.getType() != 301032 || (aliasNode = outerAliasList.get(i3)) != null) continue;
                aliasNode = (SQLAlias)nodeFactory.createNode(301028);
                aliasNode.setName(((SQLFid)child).getName());
                outerAliasList.set(((SQLFid)child).getColumnNo(), aliasNode);
            }
            List<IXQEQueryNode> fids = projection.getDescendantsOfTypeOrdered(301032, 301004);
            for (i = 0; i < fids.size(); ++i) {
                fid = (SQLFid)fids.get(i);
                fid.setName(((SQLAlias)aliasList.get(fid.getColumnNo())).getName());
                fid.setTableName(DERIVED_TABLE_NAME);
            }
            if (node.getType() == 301010) {
                groupByList = ((SQLGroupBy)node).getGroupByList();
                fids = groupByList.getDescendantsOfTypeOrdered(301032, 301004);
                for (i = 0; i < fids.size(); ++i) {
                    fid = (SQLFid)fids.get(i);
                    fid.setName(((SQLAlias)aliasList.get(fid.getColumnNo())).getName());
                    fid.setTableName(DERIVED_TABLE_NAME);
                }
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean status = false;
        SQLProject project = (SQLProject)node;
        SQLValueList vList = project.getOutputList();
        List<IXQEQueryNode> windows = vList.getDescendantsOfTypeOrdered(301041, false);
        boolean bl = status = this.getExpressions(windows).size() != 0;
        if (status) {
            if (pQueryBlock.isForeign()) {
                IDataSource dataSource = pQueryBlock.getDataSource();
                DataSourceCapabilities dsCapabilities = (DataSourceCapabilities)dataSource.getCapabilities();
                status = !dsCapabilities.isSupported("supports.expressionsInOrderBy");
            } else {
                List<IXQEQueryNode> aggregates = vList.getDescendantsOfTypeOrdered(301034, false);
                for (IXQEQueryNode queryNode : aggregates) {
                    if (queryNode.getFirstChildByType(301041) != null) continue;
                    status = false;
                    break;
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "WINDOW specification contains expressions.", trace);
        } else {
            this.traceQueryCondition(status, "WINDOW specification doesn't contain expressions.", trace);
        }
        return status;
    }

    private List<IXQEQueryNode> getExpressions(List<IXQEQueryNode> windows) {
        ArrayList<IXQEQueryNode> expr = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode window : windows) {
            IXQEQueryNode[] computeBreakList;
            IXQEQueryNode computeBreak;
            IXQEQueryNode sortKeyList;
            IXQEQueryNode partition = window.getFirstChildByType(301042);
            if (partition != null) {
                IXQEQueryNode[] partitionList;
                for (IXQEQueryNode node : partitionList = partition.getChildren()) {
                    if (node.getType() == 301032) continue;
                    expr.add(node);
                }
            }
            if ((sortKeyList = window.getFirstChildByType(301021)) != null) {
                IXQEQueryNode[] sortKeys;
                for (IXQEQueryNode node : sortKeys = sortKeyList.getChildren()) {
                    if (node.getChild(0).getType() == 301032) continue;
                    expr.add(node.getChild(0));
                }
            }
            if ((computeBreak = window.getFirstChildByType(301062)) == null) continue;
            for (IXQEQueryNode node : computeBreakList = computeBreak.getChildren()) {
                if (node.getType() == 301032) continue;
                expr.add(node);
            }
        }
        return expr;
    }

    private void eliminateConstantExpressionFromWindows(List<IXQEQueryNode> windows) {
        for (IXQEQueryNode window : windows) {
            IXQEQueryNode computeBreak;
            IXQEQueryNode sortKeyList;
            IXQEQueryNode partition = window.getFirstChildByType(301042);
            if (partition != null) {
                this.eliminateConstantExpression(partition);
            }
            if ((sortKeyList = window.getFirstChildByType(301021)) != null) {
                this.eliminateConstantExpression(sortKeyList);
            }
            if ((computeBreak = window.getFirstChildByType(301062)) == null) continue;
            this.eliminateConstantExpression(computeBreak);
        }
    }

    private IXQEQueryNode eliminateConstantExpression(IXQEQueryNode node) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = node.getChildren()) {
            if (!((SQLExpression)child).isConstantExpression()) continue;
            child.detach();
        }
        if (node.getNumberChildren() == 0) {
            node.detach();
            node = null;
        }
        return node;
    }
}

