/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public final class FlattenJoinQuery
extends RQETransformation {
    public FlattenJoinQuery() {
        this.mName = "Flatten simple join query.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock2;
        int i;
        IXQEQueryNode baseNode = null;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        SQLQueryItemList queryItemList = qBlock.getQueryItemList();
        SQLQueryItemList baseQueryItemList = qBlock.getBaseQueryItemList();
        IXQEQueryNode parent = qBlock.getParent();
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)qBlock.getAncestorOfType(301004);
        SQLValueList vList = pQueryBlock.getOutputList();
        List<SQLAlias> aliasList = vList.getAliasList();
        if (aliasList == null) {
            aliasList = new ArrayList<SQLAlias>();
            for (i = 0; i < vList.getNumberChildren(); ++i) {
                aliasList.add(null);
            }
            vList.setAliasList(aliasList);
        }
        for (i = 0; i < vList.getNumberChildren(); ++i) {
            IXQEQueryNode exprNode;
            SQLAlias alias = aliasList.get(i);
            if (alias != null || (exprNode = vList.getChild(i)).getType() != 301032) continue;
            alias = (SQLAlias)nodeFactory.createNode(301028);
            alias.setName(((SQLFid)exprNode).getName());
            aliasList.set(i, alias);
        }
        int position = parent.getPositionOfChild(node);
        int vColumnNo = 0;
        int sourceNoDelta = 0;
        int baseNodeNumberColumns = 0;
        for (int i2 = 0; i2 < position; ++i2) {
            vColumnNo += ((SQLQueryNode)parent.getChild(i2)).getNumberColumns();
        }
        List<SQLFid> fidList = child.getFieldIdentifiers();
        BitSet mask = new BitSet();
        mask.set(position, parent.getNumberChildren());
        List<SQLFid> pQueryBlockfidList = pQueryBlock.getFieldIdentifiers(parent, mask);
        baseNode = child;
        vList = (SQLValueList)baseNode.detachSecondChild();
        baseNode.extract();
        baseNode = node.getChild(0);
        while (baseNode.getType() == 301009) {
            IXQEQueryNode tmpNode = baseNode.detachSecondChild();
            parent.insertParent(baseNode.extract());
            baseNode.addChild(tmpNode);
            baseNode = node.getChild(0);
        }
        String tableName = qBlock.getName();
        if (baseNode.getType() == 301014) {
            IXQEQueryNode[] children = baseNode.getChildren();
            for (int i3 = 0; i3 < children.length; ++i3) {
                child = (SQLQueryNode)children[i3];
                if (child.getType() == 301004) {
                    qBlock2 = (SQLQueryBlock)child;
                } else {
                    qBlock2 = (SQLQueryBlock)nodeFactory.createNode(301004);
                    qBlock2.setForeign(true);
                    qBlock2.setQueryItemList(child.getQueryItemList());
                    qBlock2.setDataSource(child.getDataSource());
                    child.insertParent(qBlock2);
                }
                String tName = tableName + i3;
                qBlock2.setName(tName);
                for (SQLFid fid : fidList) {
                    if (fid.getSourceNo() != i3) continue;
                    fid.setTableName(tName);
                }
                baseNodeNumberColumns += ((SQLQueryNode)qBlock2).getNumberColumns();
            }
            baseNode.extract();
            node.extract();
            sourceNoDelta = children.length - 1;
        } else {
            if (baseNode.getType() == 301004) {
                qBlock2 = (SQLQueryBlock)baseNode;
            } else {
                qBlock2 = (SQLQueryBlock)nodeFactory.createNode(301004);
                qBlock2.setForeign(true);
                qBlock2.setQueryItemList(((SQLQueryNode)baseNode).getQueryItemList());
                qBlock2.setDataSource(qBlock.getDataSource());
                baseNode.insertParent(qBlock2);
            }
            qBlock2.setName(tableName);
            for (SQLFid fid : fidList) {
                fid.setTableName(tableName);
            }
            baseNodeNumberColumns = qBlock.getNumberColumns();
            sourceNoDelta = 0;
        }
        this.fixQueryItems(queryItemList, baseQueryItemList);
        node.extract();
        for (SQLFid fid : fidList) {
            fid.setSourceNo(fid.getSourceNo() + position);
            fid.setVirtualColumnNo(fid.getVirtualColumnNo() + vColumnNo);
        }
        int vColumnNoDelta = baseNodeNumberColumns - vList.getNumberChildren();
        for (SQLFid fid : pQueryBlockfidList) {
            if (fid.getSourceNo() == position) {
                fid.exchange(nodeFactory.deepCopyNode(vList.getChild(fid.getColumnNo())));
                continue;
            }
            fid.setSourceNo(fid.getSourceNo() + sourceNoDelta);
            fid.setVirtualColumnNo(fid.getVirtualColumnNo() + vColumnNoDelta);
        }
    }

    private void fixQueryItems(SQLQueryItemList qItemList, SQLQueryItemList baseQueryItemList) {
        for (int i = 0; i < qItemList.size(); ++i) {
            SQLQueryItem qItem1 = (SQLQueryItem)qItemList.get(i);
            int vColumnNo = qItem1.getVirtualColumnNo();
            if (vColumnNo < 0) continue;
            SQLQueryItem qItem2 = (SQLQueryItem)baseQueryItemList.get(vColumnNo);
            qItem2.setIsParameter(qItem1.isParameter());
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        IXQEQueryNode parent = qBlock.getParent();
        if (qBlock.getName() == null || qBlock.getReusableQuery() != null || qBlock.isLateralDerivedTable() || parent.getType() != 301014) {
            status = false;
        } else {
            IXQEQueryNode child = node.getChild(0);
            if (child.getType() == 301015) {
                SQLValueList vList = ((SQLProject)child).getOutputList();
                for (IXQEQueryNode eNode : vList.getChildren()) {
                    if (eNode.getType() == 301032) continue;
                    status = false;
                    break;
                }
                if (status) {
                    while (child.getType() == 301015 || child.getType() == 301009) {
                        child = child.getChild(0);
                    }
                    if (child.getType() == 301014) {
                        for (int i = 0; i < child.getNumberChildren(); ++i) {
                            if (child.getChild(i).getType() == 301016 || child.getChild(i).getType() == 301092 || child.getChild(i).getType() == 301004) continue;
                            status = false;
                            break;
                        }
                    } else if (child.getType() != 301016 && child.getType() != 301092 && child.getType() != 301004) {
                        status = false;
                    } else if (child.getType() == 301004 && child.getChild(0).getType() == 301038) {
                        status = false;
                    }
                }
            } else {
                status = false;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Query can be flattened.", trace);
        } else {
            this.traceQueryCondition(status, "Query cannot be flattened.", trace);
        }
        return status;
    }
}

