/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class FloorNumericChildren
extends RQETransformation {
    public FloorNumericChildren() {
        this.mName = "convert datetime plus numeric to Standard SQL";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301033};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLFunction.SubType subType = ((SQLFunction)node).getSubType();
        boolean bl = status = subType == SQLFunction.SubType.ADD_YEARS || subType == SQLFunction.SubType.ADD_QUARTERS || subType == SQLFunction.SubType.ADD_MONTHS || subType == SQLFunction.SubType.ADD_WEEKS || subType == SQLFunction.SubType.ADD_DAYS || subType == SQLFunction.SubType.ADD_HOURS || subType == SQLFunction.SubType.ADD_MINUTES || subType == SQLFunction.SubType.SUBSTRING || subType == SQLFunction.SubType.SUBSTRINGR;
        if (status) {
            boolean childrenStatus = false;
            for (IXQEQueryNode child : node.getChildren()) {
                if (childrenStatus |= this.childNeedsFlooring(child)) break;
            }
            status &= childrenStatus;
        }
        if (status) {
            this.traceQueryCondition(status, "Expression needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "Expression does not need to be converted.", trace);
        }
        return status;
    }

    private boolean childNeedsFlooring(IXQEQueryNode node) {
        return !this.isFloorFunction(node) && (((SQLQueryNode)node).getDataType().isDecimal() || ((SQLQueryNode)node).getDataType().isApproximateNumeric());
    }

    private boolean isFloorFunction(IXQEQueryNode node) {
        if (node instanceof SQLFunction) {
            return ((SQLFunction)node).getSubType() == SQLFunction.SubType.FLOOR;
        }
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        for (IXQEQueryNode child : node.getChildren()) {
            if (!this.childNeedsFlooring(child)) continue;
            SQLFunction floorNode = (SQLFunction)factory.createNode(301033);
            floorNode.setSubType(SQLFunction.SubType.FLOOR);
            child.insertParent(floorNode);
        }
    }
}

