/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLProduct;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;

public class GenerateJSONTableFunction
extends RQETransformation {
    private static final String EQUALS = "=";
    private static final String SEMICOLON = ";";
    private static final String DOLLAR = "$";
    private static final String DOT = ".";
    private static final String DOT_REGEX = "\\.";
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";

    public GenerateJSONTableFunction() {
        this.mName = "Generate JSONTable function specification.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301016};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock;
        XQENodeFactory factory = environment.getNodeFactory();
        IDataSource dataSource = ((SQLQueryNode)node).getDataSource();
        SQLTableFunction tblFunc = (SQLTableFunction)factory.createNode(301038);
        tblFunc.setSubType(SQLTableFunction.SubType.JSON_TABLE);
        tblFunc.setDataSource(dataSource);
        SQLRelation relation = (SQLRelation)node;
        if (node.getParent().getType() != 301004) {
            qBlock = (SQLQueryBlock)factory.createNode(301004);
            qBlock.setName(relation.getName());
            relation.insertParent(qBlock);
        } else {
            qBlock = (SQLQueryBlock)node.getParent();
        }
        qBlock.setForeign(false);
        relation.extract();
        this.addParameters(factory, tblFunc, qBlock, relation);
    }

    protected void addParameters(IXQENodeFactory factory, SQLTableFunction tblFunc, SQLQueryBlock tblFuncQBlock, SQLRelation relation) {
        String connectionString = relation.getConnectionString();
        String[] tokens = connectionString.split(SEMICOLON);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String token : tokens) {
            if (!token.contains(EQUALS)) continue;
            String key = token.substring(0, token.indexOf(EQUALS));
            String value = token.substring(key.length() + 1);
            properties.put(key, value);
        }
        Map<String, Object> metadataProps = relation.getMetadataProperties();
        String pathExpr = (String)metadataProps.get("PATH");
        if (pathExpr != null) {
            properties.put("PATH", pathExpr);
        }
        if (properties.get("PATH") == null) {
            properties.put("PATH", DOLLAR);
        }
        JSONObject jObject = new JSONObject(properties);
        SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
        literal.setValue(DataValueFactory.createObjectValue(jObject));
        tblFunc.addChild(literal);
        tblFunc.addChild(this.createLiteral(factory, (String)properties.get("PATH")));
        this.generatePathLiterals(tblFunc, tblFuncQBlock, factory);
        Map<String, SQLQueryBlock> lateralQBlocks = this.gatherLateralQBlocks(tblFuncQBlock);
        LinkedList<Pair> nestedSqlTableFunctions = new LinkedList<Pair>();
        this.generateNestedJSONTableFunctions(factory, tblFunc, tblFuncQBlock, lateralQBlocks, nestedSqlTableFunctions);
        this.generateRowTypesAndProjectionListsNestedJSONTableFuncs(nestedSqlTableFunctions, lateralQBlocks);
        this.generateRowTypeAndProjectionList(tblFunc, SQLBinderUtil.makeRowTypeFromQueryItems(relation.getQueryItemList()), relation.getQueryItemList());
        tblFunc.setIdentifierChain1(LEFT_BRACKET + tblFuncQBlock.getName() + RIGHT_BRACKET);
        ArrayList<String> updatedListOfLateralQBlocks = new ArrayList<String>();
        for (Pair p : nestedSqlTableFunctions) {
            updatedListOfLateralQBlocks.add(p.getFirst().toString());
        }
        tblFuncQBlock.setLateralSQLQueryBlocks(updatedListOfLateralQBlocks);
        ArrayList<String> updatedProjectionList = new ArrayList<String>();
        String rootId = tblFunc.getIdentifierChain1();
        for (String pjId : tblFunc.getProjectionList()) {
            updatedProjectionList.add(rootId + DOT + pjId);
        }
        tblFuncQBlock.setProjectionList(updatedProjectionList);
        tblFuncQBlock.setQueryItemList(tblFunc.getQueryItemList());
        this.updateFids(tblFuncQBlock);
        this.cleanUpQueryBlocksAndProduct(tblFuncQBlock, nestedSqlTableFunctions, lateralQBlocks);
        tblFuncQBlock.addChild(tblFunc);
    }

    private Map<String, SQLQueryBlock> gatherLateralQBlocks(SQLQueryBlock tblFuncQBlock) {
        HashMap<String, SQLQueryBlock> lateralQBlocks = new HashMap<String, SQLQueryBlock>();
        IXQEQueryNode node = tblFuncQBlock.getAncestorOfType(301014);
        if (node != null && node instanceof SQLProduct) {
            SQLProduct sqlProdNode = (SQLProduct)node;
            for (IXQEQueryNode lateralQBlock : sqlProdNode.getChildren()) {
                SQLQueryBlock current = (SQLQueryBlock)lateralQBlock;
                lateralQBlocks.put(current.getName(), current);
            }
        }
        return lateralQBlocks;
    }

    private void generateNestedJSONTableFunctions(IXQENodeFactory factory, SQLTableFunction rootSQLTblFun, SQLQueryBlock rootSQLTblFunQB, Map<String, SQLQueryBlock> lateralQBlocks, List<Pair> sqlTableFunctions) {
        ArrayList<String> lateralSQLQueryBlockNames = rootSQLTblFunQB.getLateralSQLQueryBlocks();
        if (lateralSQLQueryBlockNames != null) {
            for (String lateralQBName : lateralSQLQueryBlockNames) {
                SQLQueryBlock qb = lateralQBlocks.get(lateralQBName);
                SQLTableFunction nestedTblFun = (SQLTableFunction)factory.createNode(301038);
                nestedTblFun.setIsNested(true);
                nestedTblFun.setSubType(SQLTableFunction.SubType.JSON_TABLE);
                nestedTblFun.addChild(this.generateInitialPathLiteralForNestedTblFns(nestedTblFun, qb, factory));
                this.generatePathLiterals(nestedTblFun, qb, factory);
                rootSQLTblFun.addChild(nestedTblFun);
                rootSQLTblFun.setQueryItemList(rootSQLTblFunQB.getQueryItemList());
                sqlTableFunctions.add(new Pair(qb.getName(), nestedTblFun));
                this.generateNestedJSONTableFunctions(factory, nestedTblFun, qb, lateralQBlocks, sqlTableFunctions);
            }
        }
    }

    private void generateRowTypesAndProjectionListsNestedJSONTableFuncs(LinkedList<Pair> sqlTableFunctions, Map<String, SQLQueryBlock> lateralQBlocks) {
        Iterator<Pair> descIt = sqlTableFunctions.descendingIterator();
        while (descIt.hasNext()) {
            Pair qbNameSQLTableFun = descIt.next();
            SQLQueryBlock qb = lateralQBlocks.get(qbNameSQLTableFun.getFirst());
            RowType rowType = (RowType)((SQLTableFunction)qb.getChild(0)).getDataType();
            this.generateRowTypeAndProjectionList((SQLTableFunction)qbNameSQLTableFun.getSecond(), rowType, qb.getQueryItemList());
        }
    }

    private void generateRowTypeAndProjectionList(SQLTableFunction tblFun, RowType rowType, SQLQueryItemList sqlQIList) {
        int offset = 0;
        offset = tblFun.isNested() ? 1 : 2;
        RowType generatedRowType = DataTypeFactory.getRowType();
        SQLQueryItemList updatedQIList = new SQLQueryItemList();
        IXQEQueryNode[] children = tblFun.getChildren();
        for (int i = offset; i < children.length; ++i) {
            if (children[i] instanceof SQLLiteral) {
                SQLQueryItem sqlQIPointer = null;
                DataType dataTypePointer = rowType;
                String[] nameParts = ((SQLLiteral)children[i]).getValue().getString().split(DOT_REGEX);
                nameParts = Arrays.copyOfRange(nameParts, 1, nameParts.length);
                Boolean isVeryFirst = true;
                for (int j = 0; j < nameParts.length; ++j) {
                    String currentNamePart = nameParts[j];
                    dataTypePointer = (DataType)dataTypePointer.getFieldDataType(currentNamePart);
                    sqlQIPointer = isVeryFirst == false ? sqlQIPointer.getAttributeList().getQueryItem(currentNamePart) : sqlQIList.getQueryItem(currentNamePart);
                    isVeryFirst = false;
                }
                generatedRowType.addField(nameParts[nameParts.length - 1], dataTypePointer);
                updatedQIList.add(sqlQIPointer);
                tblFun.addToProjectionList(UniqueNameGenerator.createUniqueName(nameParts));
                continue;
            }
            RowType nestedRowType = (RowType)((SQLTableFunction)children[i]).getDataType();
            for (int j = 0; j < nestedRowType.getNumberColumns(); ++j) {
                generatedRowType.addField(nestedRowType.getFieldName(j), nestedRowType.getFieldDataType(j));
            }
            updatedQIList.addAll(((SQLTableFunction)children[i]).getQueryItemList());
            List<String> nestedProjectionList = ((SQLTableFunction)children[i]).getProjectionList();
            String rootIdChain = ((SQLTableFunction)children[i]).getIdentifierChain1();
            for (String pjId : nestedProjectionList) {
                tblFun.addToProjectionList(rootIdChain + DOT + pjId);
            }
        }
        tblFun.setDataType(generatedRowType);
        tblFun.setQueryItemList(updatedQIList);
    }

    private SQLLiteral createLiteral(IXQENodeFactory factory, String value) {
        SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
        literal.setValue(DataValueFactory.createCharValue(value));
        return literal;
    }

    private SQLLiteral generateInitialPathLiteralForNestedTblFns(SQLTableFunction tblFun, SQLQueryBlock qb, IXQENodeFactory factory) {
        LinkedList<String> pathExpressionParts = new LinkedList<String>();
        SQLXid xid = (SQLXid)qb.getDescendantsOfType(301082, false)[0];
        pathExpressionParts.add(xid.getName());
        for (IXQEQueryNode potentialFid = xid.getParent(); potentialFid != null && potentialFid instanceof SQLFid; potentialFid = potentialFid.getParent()) {
            SQLFid currentFid = (SQLFid)potentialFid;
            pathExpressionParts.add(currentFid.getName());
        }
        StringBuilder sb = new StringBuilder(DOLLAR);
        for (String name : pathExpressionParts) {
            sb.append(DOT);
            sb.append(name);
        }
        tblFun.setIdentifierChain1(UniqueNameGenerator.createUniqueName(pathExpressionParts.toArray(new String[pathExpressionParts.size()])));
        sb.append("[*]");
        return this.createLiteral(factory, sb.toString());
    }

    private void generatePathLiterals(SQLTableFunction tblFun, SQLQueryBlock qb, IXQENodeFactory factory) {
        ArrayList<String> pjList = qb.getProjectionList();
        if (pjList == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String chainIdentifier : pjList) {
            String[] nameParts;
            sb.append(DOLLAR);
            for (String name : nameParts = chainIdentifier.split(DOT_REGEX)) {
                sb.append(DOT);
                sb.append(name.substring(1, name.length() - 1));
            }
            tblFun.addChild(this.createLiteral(factory, sb.toString()));
            sb.setLength(0);
        }
    }

    private void cleanUpQueryBlocksAndProduct(SQLQueryBlock rootTblFuncQBlock, List<Pair> nestedSQLTableFunctions, Map<String, SQLQueryBlock> lateralQBlocks) {
        SQLProduct sqlProduct;
        ArrayList<String> updatedListOfLateralQBlocks = new ArrayList<String>();
        for (Pair pair : nestedSQLTableFunctions) {
            String qbName = pair.getFirst().toString();
            SQLQueryBlock qb = lateralQBlocks.get(qbName);
            qb.detach();
            updatedListOfLateralQBlocks.add(qbName);
        }
        IXQEQueryNode potentialSQLProductNode = rootTblFuncQBlock.getParent();
        if (potentialSQLProductNode instanceof SQLProduct && (sqlProduct = (SQLProduct)potentialSQLProductNode).getNumberChildren() == 1) {
            sqlProduct.extract();
        }
    }

    private void updateFids(SQLQueryBlock tblFuncQBlock) {
        IXQEQueryNode[] fids;
        SQLQueryBlock cteQB = (SQLQueryBlock)tblFuncQBlock.getAncestorOfType(301004);
        ArrayList<String> lateralQBlocksTBD = tblFuncQBlock.getLateralSQLQueryBlocks();
        int qbSourceNo = 0;
        ArrayList<Integer> lateralQBlocksTBDSourceNos = new ArrayList<Integer>();
        IXQEQueryNode potentialSQLProduct = tblFuncQBlock.getParent();
        if (potentialSQLProduct instanceof SQLProduct) {
            qbSourceNo = potentialSQLProduct.getPositionOfChild(tblFuncQBlock);
            block0: for (String lateralQBName : lateralQBlocksTBD) {
                int index = 0;
                for (IXQEQueryNode qbChild : potentialSQLProduct.getChildren()) {
                    if (((SQLQueryBlock)qbChild).getName().equals(lateralQBName)) {
                        lateralQBlocksTBDSourceNos.add(index);
                        continue block0;
                    }
                    ++index;
                }
            }
        }
        for (IXQEQueryNode fid : fids = cteQB.getDescendantsOfType(301032, false, 301004)) {
            SQLFid current = (SQLFid)fid;
            if (current.getParent() == null || current.getParent().getType() == 301032) continue;
            LinkedList<String> currentNamePartsRv = new LinkedList<String>();
            currentNamePartsRv.add(current.getName());
            List<IXQEQueryNode> currentDescendants = fid.getDescendantsOfTypeOrdered(301032, false);
            for (IXQEQueryNode descendant : currentDescendants) {
                currentNamePartsRv.add(((SQLFid)descendant).getName());
            }
            String currentTblName = current.getTableName();
            if (currentTblName == null) {
                currentTblName = ((SQLFid)currentDescendants.get(currentDescendants.size() - 1)).getTableName();
            }
            int currentSourceNo = current.getSourceNo();
            if (lateralQBlocksTBD.contains(currentTblName) || currentTblName.equals(tblFuncQBlock.getName())) {
                current.setSourceNo(qbSourceNo);
                ArrayList<String> pjList = tblFuncQBlock.getProjectionList();
                for (int i = pjList.size() - 1; i >= 0; --i) {
                    boolean totalMatch = true;
                    String[] partNames = pjList.get(i).split(DOT_REGEX);
                    Iterator it = currentNamePartsRv.iterator();
                    for (int j = partNames.length - 1; j >= 0 && it.hasNext(); --j) {
                        String pName = partNames[j];
                        if ((pName = pName.substring(1, pName.length() - 1)).equals(it.next())) continue;
                        totalMatch = false;
                        break;
                    }
                    if (!totalMatch) continue;
                    current.setColumnNo(i);
                    current.setVirtualColumnNo(i);
                    break;
                }
            } else {
                int offset = 0;
                Iterator iterator = lateralQBlocksTBDSourceNos.iterator();
                while (iterator.hasNext()) {
                    int lateralQBTBDSourceNo = (Integer)iterator.next();
                    if (lateralQBTBDSourceNo >= currentSourceNo) continue;
                    ++offset;
                }
                current.setSourceNo(currentSourceNo - offset);
            }
            if (currentDescendants.isEmpty()) continue;
            currentDescendants.get(0).detach();
            current.setVirtualColumnNo(((SQLFid)currentDescendants.get(currentDescendants.size() - 1)).getVirtualColumnNo());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IDataSource dataSource = ((SQLQueryNode)node).getDataSource();
        boolean bl = status = dataSource != null && DataSourceTypeEnum.isJSON(dataSource.getType()) && !DataSourceTypeEnum.isCouchDB(dataSource.getType()) && !DataSourceTypeEnum.isCloudant(dataSource.getType()) && !((SQLRelation)node).isWithClauseQueryRef();
        if (status) {
            this.traceQueryCondition(status, "JSONTable function needs to be generated.", trace);
        } else {
            this.traceQueryCondition(status, "JSONTable function does not need to be generated.", trace);
        }
        return status;
    }
}

