/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.BitSet;

public class RemoveRedundantSQLDistinct
extends RQETransformation {
    public RemoveRedundantSQLDistinct() {
        this.mName = "Remove a redundant DISTINCT node.";
        this.mPassNumbers = new int[]{21};
        this.mTypes = new int[]{301008};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode descendant = node.getChild(0);
        if (descendant.getType() == 301010) {
            status = true;
        } else if (descendant.getType() == 301015) {
            status = true;
            SQLValueList vList = ((SQLProject)descendant).getOutputList();
            for (IXQEQueryNode expr : vList.getChildren()) {
                if (expr.getType() == 301032) continue;
                status = false;
                break;
            }
            if (status) {
                if ((descendant = this.getDescendantQueryBlock(descendant)) == null || descendant.getChild(0).getType() != 301010) {
                    status = false;
                } else {
                    SQLGroupBy groupBy = (SQLGroupBy)descendant.getChild(0);
                    SQLValueList vList2 = groupBy.getOutputList();
                    SQLGroupByList gList = groupBy.getGroupByList();
                    if (vList.getNumberChildren() != vList2.getNumberChildren()) {
                        BitSet bits = new BitSet();
                        for (IXQEQueryNode expr : vList.getChildren()) {
                            SQLFid fid = (SQLFid)expr;
                            IXQEQueryNode expr2 = vList2.getChild(fid.getColumnNo());
                            int index = gList.indexOf(expr2);
                            if (index < 0) {
                                status = false;
                                break;
                            }
                            bits.set(index);
                        }
                        if (bits.cardinality() != gList.getNumberChildren()) {
                            status = false;
                        }
                    }
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "DISTINCT node can be removed.", trace);
        } else {
            this.traceQueryCondition(status, "DISTINCT cannot be removed.", trace);
        }
        return status;
    }

    private IXQEQueryNode getDescendantQueryBlock(IXQEQueryNode root) {
        if (root.getType() == 301004) {
            return root;
        }
        if (root.getType() == 301015 || root.getType() == 301010 || root.getType() == 301009) {
            return this.getDescendantQueryBlock(root.getChild(0));
        }
        return null;
    }
}

