/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.util.RQEUtil;

public final class ReplaceSQLQueryBlock
extends RQETransformation {
    public ReplaceSQLQueryBlock() {
        this.mName = "Replace SQLQueryBlock node.";
        this.mPassNumbers = new int[]{23};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        String sProp;
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        SQLRangeVar rangeVar = (SQLRangeVar)environment.getNodeFactory().createNode(301007);
        RQEUtil.transferNoCache(qBlock, rangeVar);
        rangeVar.setName(qBlock.getName());
        rangeVar.setDerivedColumnList(qBlock.getDerivedColumnList());
        rangeVar.setDerivedColumnTypes(qBlock.getDerivedColumnTypes());
        rangeVar.setHints(qBlock.getHints());
        rangeVar.setLateral(qBlock.isLateralDerivedTable());
        if (qBlock.getReferenceCount() != 0) {
            rangeVar.setReferenceCount(qBlock.getReferenceCount());
        }
        if ((sProp = (String)qBlock.getPropertyValue("dbHint")) != null) {
            rangeVar.setPropertyValue("dbHint", sProp);
        }
        node.exchange(rangeVar, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = pQueryBlock != null && pQueryBlock.isForeign() && qBlock.isForeign() && qBlock.getName() != null;
        if (status) {
            this.traceQueryCondition(status, "The query block is supported and can be replaced.", trace);
        } else {
            this.traceQueryCondition(status, "The query block is not supported and cannot be replaced.", trace);
        }
        return status;
    }
}

