/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLNull;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSearchedCase;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWhen;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class RewriteConcatenationExpression
extends RQETransformation {
    private static final String PROB_BOOL_REWRITE_CONCAT = "rewriteConcatenationExpression";

    public RewriteConcatenationExpression() {
        this.mName = "Analyze and Transform Concatenation";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301025};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        ArrayList<IXQEQueryNode> newCaseList = new ArrayList<IXQEQueryNode>();
        this.addToCaseList(newCaseList, node, environment);
        if (newCaseList.size() == 0) {
            node.setPropertyValue(PROB_BOOL_REWRITE_CONCAT, true);
            return;
        }
        SQLSearchedCase newSearchedCase = (SQLSearchedCase)factory.createNode(301074);
        SQLValueList newValueList = (SQLValueList)factory.createNode(301030);
        newSearchedCase.addChild(newValueList, 0);
        SQLWhen whenNode = (SQLWhen)factory.createNode(301048);
        newValueList.addChild(whenNode);
        IXQEQueryNode topNode = whenNode;
        for (int i = 0; i < newCaseList.size(); ++i) {
            SQLIsNull isNullNode = (SQLIsNull)factory.createNode(301024);
            isNullNode.addChild((IXQEQueryNode)newCaseList.get(i));
            if (i > 0) {
                SQLLogical orNode = (SQLLogical)factory.createNode(301027);
                orNode.setSubType(SQLLogical.SubType.OR);
                topNode.insertParent(orNode);
                topNode = topNode.getParent();
                topNode.addChild(isNullNode);
                continue;
            }
            topNode = isNullNode;
        }
        whenNode.addChild(topNode);
        SQLNull nullNode = (SQLNull)factory.createNode(301050);
        whenNode.addChild(nullNode);
        IXQEQueryNode parentNode = node.getParent();
        int position = parentNode.getPositionOfChild(node);
        newSearchedCase.addChild(parentNode.detachChild(node));
        node.setPropertyValue(PROB_BOOL_REWRITE_CONCAT, true);
        parentNode.addChild(newSearchedCase, position);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = ((SQLValueExpression)node).getSubType().equals((Object)SQLValueExpression.SubType.CONCATENATE) && (node.getParent().getType() != 301025 || !((SQLValueExpression)node.getParent()).getSubType().equals((Object)SQLValueExpression.SubType.CONCATENATE));
        if (status) {
            SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
            IDataSource dataSource = pQueryBlock.getDataSource();
            boolean concatNullIsNull = dataSource != null && dataSource.getCapabilities().isSupported("supports.concatNullIsNull");
            status = !concatNullIsNull && node.getPropertyValue(PROB_BOOL_REWRITE_CONCAT) == null;
        }
        if (status) {
            this.traceQueryCondition(status, "Concatenation Expression need to be rewritten.", trace);
        } else {
            this.traceQueryCondition(status, "Concatenation Expression does not need to be rewritten.", trace);
        }
        return status;
    }

    private void addToCaseList(List<IXQEQueryNode> caseList, IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        if (node.getType() != 301025 || !((SQLValueExpression)node).getSubType().equals((Object)SQLValueExpression.SubType.CONCATENATE)) {
            if (!((SQLExpression)node).isConstantExpression()) {
                caseList.add(factory.deepCopyNode(node));
            }
        } else {
            this.addToCaseList(caseList, node.getChild(0), environment);
            this.addToCaseList(caseList, node.getChild(1), environment);
        }
    }
}

