/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLProduct;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.transformation.relational.preoptimization.RewriteSubqueryAsJoin;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RewriteExistsSubqueryAsJoin
extends RewriteSubqueryAsJoin {
    private static final String JOIN_METHOD = "joinMethod";
    private static final String SEMI_JOIN = "'semi'";

    public RewriteExistsSubqueryAsJoin() {
        this.mName = "Convert an EXISTS correlated subquery to a join.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{301059};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean addSemiJoinHint;
        SQLProduct pNode;
        XQENodeFactory factory = environment.getNodeFactory();
        int contextNo = 0;
        if (((SQLSubQuery)node).hasParentSubQuery()) {
            SQLSubQuery parentSubQuery = (SQLSubQuery)node.getAncestorOfType(301059);
            contextNo = parentSubQuery.getContextNo();
        }
        SQLQueryNode predicate = (SQLQueryNode)node.getParent();
        IXQEQueryNode subQuery = node.detach();
        SQLQueryBlock qBlock = (SQLQueryBlock)subQuery.getChild(0).detach();
        IDataSource dataSource = qBlock.getDataSource();
        IXQEQueryNode root = qBlock.getChild(0);
        while (!root.isOfCategory(301015)) {
            root = root.getChild(0);
        }
        SQLValueList vList = ((SQLProject)root).getOutputList();
        IXQEQueryNode baseNode1 = predicate.getParent();
        while (baseNode1.getType() == 301009) {
            baseNode1 = baseNode1.getChild(0);
        }
        if (baseNode1.getType() != 301014) {
            pNode = (SQLProduct)factory.createNode(301014);
            baseNode1.insertParent(pNode);
        } else {
            pNode = (SQLProduct)baseNode1;
        }
        int sourceNo = pNode.getNumberChildren();
        qBlock.setName(String.format("T_$%d", sourceNo));
        pNode.addChild(qBlock);
        List<SQLAlias> aliasList = vList.getAliasList();
        if (aliasList == null) {
            aliasList = new ArrayList<SQLAlias>();
            vList.setAliasList(aliasList);
        } else {
            aliasList.clear();
        }
        predicate.getParent().extract();
        predicate.extract();
        vList.detachChildren();
        IXQEQueryNode child = root.getChild(0);
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        while (child.getType() == 301009) {
            SQLFilter factor = (SQLFilter)child;
            child = child.getChild(0);
            if (!factor.isCorrelated()) continue;
            factorList.add(factor);
        }
        boolean bl = addSemiJoinHint = dataSource.getCapabilities().isSupported("performance.semiJoin") && contextNo == 0;
        if (!addSemiJoinHint && root.getParent().getType() != 301008) {
            root.insertParent(factory.createNode(301008));
        }
        for (SQLFilter factor : factorList) {
            List<SQLXid> xidList = CollectionCast.downcast(factor.getPredicate().getDescendantsOfTypeOrdered(301082, 301004), IXQEQueryNode.class, SQLXid.class);
            predicate = (SQLQueryNode)factor.getPredicate().detach();
            pNode.insertParent(factor.extract());
            factor.addChild(predicate);
            if (addSemiJoinHint) {
                Map<String, Object> hints = predicate.getOrAddHints();
                hints.put(JOIN_METHOD, SEMI_JOIN);
                if (predicate.getChild(0).getType() == 301032) {
                    predicate.addChild(predicate.getChild(0).detach());
                }
            }
            List<SQLFid> fidList = CollectionCast.downcast(predicate.getDescendantsOfTypeOrdered(301032, 301004), IXQEQueryNode.class, SQLFid.class);
            for (SQLFid fid2 : fidList) {
                SQLAlias alias;
                String name;
                SQLFid fid;
                int columnNo = vList.indexOf(fid2);
                if (columnNo < 0) {
                    columnNo = vList.getNumberChildren();
                    fid = (SQLFid)factory.createNode(301032);
                    fid2.copyContentTo(factory, fid);
                    vList.addChild(fid);
                    name = String.format("C_$%d", columnNo);
                    alias = (SQLAlias)factory.createNode(301028);
                    alias.setName(name);
                    aliasList.add(alias);
                } else {
                    alias = vList.getAliasList().get(columnNo);
                    name = alias.getName();
                }
                fid = (SQLFid)factory.createNode(301032);
                fid.setSourceNo(sourceNo);
                fid.setColumnNo(columnNo);
                fid.setTableName(qBlock.getName());
                fid.setName(name);
                fid.setDataType(fid2.getDataType());
                fid2.exchange(fid);
            }
            for (SQLXid xid : xidList) {
                SQLFid fid = (SQLFid)factory.createNode(301032);
                xid.copyContentTo(factory, fid);
                xid.exchange(fid);
            }
            FactorAnalyzer.analyze(factor);
        }
        qBlock.setNumberColumns(vList.getNumberChildren());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLSubQuery subQuery = (SQLSubQuery)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IXQEQueryNode predicate = subQuery.getParent();
        boolean bl = status = qBlock != null && qBlock.isForeign() && predicate.getType() == 301054 && predicate.getParent().getType() == 301009 && subQuery.rewriteAsJoin();
        if (status && subQuery.isCorrelatedSubQuery()) {
            IXQEQueryNode root = subQuery.getChild(0).getChild(0);
            while (!root.isOfCategory(301015)) {
                root = root.getChild(0);
            }
            IXQEQueryNode child = root.getChild(0);
            int nEquiJoins = 0;
            while (child.getType() == 301009) {
                SQLFilter factor = (SQLFilter)child;
                if (factor.isCorrelated() && factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) {
                    ++nEquiJoins;
                }
                child = child.getChild(0);
            }
            boolean bl2 = status = nEquiJoins > 0;
        }
        if (status) {
            this.traceQueryCondition(status, "EXISTS correlated subquery can be converted to a join.", trace);
        } else {
            this.traceQueryCondition(status, "EXISTS correlated subquery cannot be converted to a join.", trace);
        }
        return status;
    }
}

