/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class RewriteIsDistinctFromPredicate
extends RQETransformation {
    public RewriteIsDistinctFromPredicate() {
        this.mName = "Rewrite IS DISTINCT FROM predicate.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301075};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode predicate = null;
        IXQEQueryNode leftChild = node.getChild(0);
        IXQEQueryNode rightChild = node.getChild(1);
        for (int i = 0; i < leftChild.getNumberChildren(); ++i) {
            IXQEQueryNode isDistinctFromNode = factory.createNode(301075);
            isDistinctFromNode.addChild(leftChild.getChild(i));
            isDistinctFromNode.addChild(rightChild.getChild(i));
            if (predicate == null) {
                predicate = isDistinctFromNode;
                continue;
            }
            SQLLogical andNode = (SQLLogical)factory.createNode(301027);
            andNode.setSubType(SQLLogical.SubType.OR);
            andNode.addChild(predicate);
            andNode.addChild(isDistinctFromNode);
            predicate = andNode;
        }
        node.exchange(predicate);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = dataSource != null && node.getChild(0).getType() == 301040 && !node.isSupported(dataSource);
        if (status) {
            this.traceQueryCondition(status, "The IS DISTINCT FROM predicate needs to be rewritten.", trace);
        } else {
            this.traceQueryCondition(status, "The IS DISTINCT FROM predicate does not need to be rewritten.", trace);
        }
        return status;
    }
}

