/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class RewriteNotExistsSubqueryAsOuterJoin
extends RQETransformation {
    public RewriteNotExistsSubqueryAsOuterJoin() {
        this.mName = "Rewrite a NOT EXISTS subquery as a left-outer join.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{301059};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode predicate = node.getParent();
        SQLFilter filter = (SQLFilter)predicate.getGrandParent();
        SQLSubQuery subQuery = (SQLSubQuery)node.detach();
        SQLQueryBlock qBlock = (SQLQueryBlock)subQuery.getChild(0).detach();
        IXQEQueryNode root = qBlock.getChild(0);
        while (!root.isOfCategory(301015)) {
            root = root.getChild(0);
        }
        SQLValueList vList = ((SQLProject)root).getOutputList();
        IXQEQueryNode baseNode1 = filter;
        while (baseNode1.getType() == 301009) {
            baseNode1 = baseNode1.getChild(0);
        }
        SQLJoin jNode = (SQLJoin)factory.createNode(301011);
        jNode.setJoinType(SQLJoin.SubType.LEFT_OUTER);
        baseNode1.insertParent(jNode);
        jNode.addChild(qBlock);
        int sourceNo = jNode.getNumberOfLeafNodes() - 1;
        qBlock.setName(String.format("T_$%d", sourceNo));
        List<SQLAlias> aliasList = vList.getAliasList();
        if (aliasList == null) {
            aliasList = new ArrayList<SQLAlias>();
            vList.setAliasList(aliasList);
        } else {
            aliasList.clear();
        }
        predicate.getParent().extract();
        predicate.extract();
        if (root.getParent().getType() != 301008) {
            root.insertParent(factory.createNode(301008));
        }
        vList.detachChildren();
        IXQEQueryNode child = root.getChild(0);
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        while (child.getType() == 301009) {
            factorList.add((SQLFilter)child);
            child = child.getChild(0);
        }
        IXQEQueryNode joinPredicate = null;
        for (SQLFilter factor : factorList) {
            List<SQLXid> xidList = CollectionCast.downcast(factor.getPredicate().getDescendantsOfTypeOrdered(301082, 301004), IXQEQueryNode.class, SQLXid.class);
            if (xidList.size() == 0) continue;
            predicate = (SQLQueryNode)factor.getPredicate().detach();
            if (joinPredicate == null) {
                joinPredicate = predicate;
            } else {
                SQLLogical logicalNode = (SQLLogical)factory.createNode(301027);
                logicalNode.setSubType(SQLLogical.SubType.AND);
                logicalNode.addChild(joinPredicate);
                logicalNode.addChild(predicate);
                joinPredicate = logicalNode;
            }
            factor.extract();
            List<SQLFid> fidList = CollectionCast.downcast(predicate.getDescendantsOfTypeOrdered(301032, 301004), IXQEQueryNode.class, SQLFid.class);
            for (SQLFid fid2 : fidList) {
                SQLAlias alias;
                String name;
                SQLFid fid;
                int columnNo = vList.indexOf(fid2);
                if (columnNo < 0) {
                    columnNo = vList.getNumberChildren();
                    fid = (SQLFid)factory.createNode(301032);
                    fid2.copyContentTo(factory, fid);
                    vList.addChild(fid);
                    name = String.format("C_$%d", columnNo);
                    alias = (SQLAlias)factory.createNode(301028);
                    alias.setName(name);
                    aliasList.add(alias);
                } else {
                    alias = vList.getAliasList().get(columnNo);
                    name = alias.getName();
                }
                fid = (SQLFid)factory.createNode(301032);
                fid.setSourceNo(sourceNo);
                fid.setColumnNo(columnNo);
                fid.setTableName(qBlock.getName());
                fid.setName(name);
                fid.setDataType(fid2.getDataType());
                fid2.exchange(fid);
            }
            for (SQLXid xid : xidList) {
                SQLFid fid = (SQLFid)factory.createNode(301032);
                xid.copyContentTo(factory, fid);
                xid.exchange(fid);
            }
        }
        jNode.addChild(joinPredicate);
        SQLFid fid = (SQLFid)factory.createNode(301032);
        fid.setSourceNo(sourceNo);
        fid.setColumnNo(0);
        fid.setTableName(qBlock.getName());
        fid.setName(vList.getAlias(0));
        fid.setDataType(((SQLQueryNode)vList.getChild(0)).getDataType());
        predicate = factory.createNode(301024);
        predicate.addChild(factory.copyNode(fid));
        filter.addChild(predicate);
        FactorAnalyzer.analyze(filter);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLSubQuery subQuery = (SQLSubQuery)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getChild(0);
        IXQEQueryNode predicate = node.getParent();
        boolean bl = status = qBlock.isForeign() && predicate.getType() == 301054 && predicate.getParent().getType() == 301027 && ((SQLLogical)predicate.getParent()).getSubType() == SQLLogical.SubType.NOT && subQuery.rewriteAsJoin();
        if (status) {
            IXQEQueryNode baseNode = predicate.getGrandParent();
            while (baseNode.getType() == 301009) {
                baseNode = baseNode.getChild(0);
            }
            boolean bl2 = status = baseNode.getType() != 301014;
        }
        if (status) {
            this.traceQueryCondition(status, "Subquery can be converted to a join.", trace);
        } else {
            this.traceQueryCondition(status, "Subquery cannot be converted to a join.", trace);
        }
        return status;
    }
}

