/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RewriteNotInSubqueryAsOuterJoin
extends RQETransformation {
    public RewriteNotInSubqueryAsOuterJoin() {
        this.mName = "Rewrite a NOT IN subquery as a left-outer join.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{301059};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode predicate = node.getParent();
        SQLFilter filter = (SQLFilter)predicate.getGrandParent();
        SQLSubQuery subQuery = (SQLSubQuery)node.detach();
        SQLQueryBlock qBlock = (SQLQueryBlock)subQuery.getChild(0).detach();
        IXQEQueryNode root = qBlock.getChild(0);
        while (!root.isOfCategory(301015)) {
            root = root.getChild(0);
        }
        SQLValueList vList = ((SQLProject)root).getOutputList();
        IXQEQueryNode baseNode = filter;
        while (baseNode.getType() == 301009) {
            baseNode = baseNode.getChild(0);
        }
        SQLJoin jNode = (SQLJoin)factory.createNode(301011);
        jNode.setJoinType(SQLJoin.SubType.LEFT_OUTER);
        baseNode.insertParent(jNode);
        int sourceNo = jNode.getNumberChildren();
        qBlock.setName(String.format("T_$%d", sourceNo));
        jNode.addChild(qBlock);
        Map<String, Object> hints = qBlock.getOrAddHints();
        hints.put("enforce_not_null", true);
        List<SQLAlias> aliasList = vList.getAliasList();
        if (aliasList == null) {
            aliasList = new ArrayList<SQLAlias>();
            SQLAlias alias = (SQLAlias)factory.createNode(301028);
            alias.setName("C_$0");
            aliasList.add(alias);
            vList.setAliasList(aliasList);
        }
        SQLFid fid = (SQLFid)factory.createNode(301032);
        fid.setSourceNo(sourceNo);
        fid.setColumnNo(0);
        fid.setTableName(qBlock.getName());
        fid.setName(vList.getAlias(0));
        fid.setDataType(((SQLQueryNode)vList.getChild(0)).getDataType());
        predicate.getParent().extract();
        predicate.move(jNode);
        predicate.addChild(fid);
        SQLComparison compareExpr = (SQLComparison)factory.createNode(301026);
        compareExpr.setSubType(SQLComparison.SubType.EQUAL);
        predicate.exchange(compareExpr, true);
        predicate = factory.createNode(301024);
        predicate.addChild(factory.copyNode(fid));
        filter.addChild(predicate);
        FactorAnalyzer.analyze(filter);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLSubQuery subQuery = (SQLSubQuery)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getChild(0);
        IXQEQueryNode predicate = node.getParent();
        boolean bl = status = subQuery.rewriteAsJoin() && qBlock.isForeign() && predicate.getType() == 301076 && predicate.getParent().getType() == 301027 && ((SQLLogical)predicate.getParent()).getSubType() == SQLLogical.SubType.NOT;
        if (status) {
            SQLExpression exprNode = (SQLExpression)predicate.getChild(0);
            boolean bl2 = status = !exprNode.isNullable();
        }
        if (status) {
            IXQEQueryNode baseNode = subQuery.getGrandParent().getParent();
            while (baseNode.getType() == 301009) {
                baseNode = baseNode.getChild(0);
            }
            boolean bl3 = status = baseNode.getType() != 301014;
        }
        if (status) {
            this.traceQueryCondition(status, "Subquery can be converted to a join.", trace);
        } else {
            this.traceQueryCondition(status, "Subquery cannot be converted to a join.", trace);
        }
        return status;
    }
}

