/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class RewriteSimpleTruthValuePredicate
extends RQETransformation {
    public RewriteSimpleTruthValuePredicate() {
        this.mName = "RewriteSimpleTruthValuePredicate.";
        this.mPassNumbers = new int[]{10, 16};
        this.mTypes = new int[]{301009, 301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode predicate = node.getType() == 301009 ? ((SQLFilter)node).getPredicate() : ((SQLJoin)node).getPredicate();
        Value value = ((SQLLiteral)predicate).getValue();
        if (node.getType() == 301009 && value.getBoolean()) {
            predicate.detach();
            node.extract();
            return;
        }
        int v1 = 0;
        int v2 = 1;
        if (value.getBoolean()) {
            v1 = 1;
        }
        if (node.getType() == 301011 && ((SQLJoin)node).getJoinType() == SQLJoin.SubType.INNER && v1 == v2) {
            predicate.detach();
            ((SQLJoin)node).setJoinType(SQLJoin.SubType.CROSS);
            return;
        }
        XQENodeFactory factory = environment.getNodeFactory();
        SQLComparison compNode = (SQLComparison)factory.createNode(301026);
        compNode.setSubType(SQLComparison.SubType.EQUAL);
        SQLLiteral literalNode1 = (SQLLiteral)factory.createNode(301031);
        literalNode1.setValue(DataValueFactory.createSmallintValue(v1));
        SQLLiteral literalNode2 = (SQLLiteral)factory.createNode(301031);
        literalNode2.setValue(DataValueFactory.createSmallintValue(v2));
        compNode.addChild(literalNode1);
        compNode.addChild(literalNode2);
        compNode.setAlwaysFalse(true);
        compNode.setPropertyValue("foldingApplied", Boolean.TRUE);
        predicate.exchange(compNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode predicate = node.getType() == 301009 ? ((SQLFilter)node).getPredicate() : ((SQLJoin)node).getPredicate();
        boolean bl = status = predicate != null && predicate.getType() == 301031 && ((SQLLiteral)predicate).getDataType().isBoolean();
        if (status) {
            this.traceQueryCondition(status, "Boolean literal can be replaced.", trace);
        } else {
            this.traceQueryCondition(status, "Boolean literal cannot be replaced.", trace);
        }
        return status;
    }
}

