/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLComputeBreak;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.util.Ordering;
import java.util.ArrayList;
import java.util.List;

public final class SQLPreoptimizerUtil {
    private static final int C_3 = 3;
    private static final int C_4 = 4;

    public static SQLValueList buildProjection(IPlanningEnvironment environment, List<IXQEQueryNode> exprNodeList, IDataSource dataSource) {
        return SQLPreoptimizerUtil.buildProjection(environment, exprNodeList, 0, 0, dataSource);
    }

    public static SQLValueList buildProjection(IPlanningEnvironment environment, List<IXQEQueryNode> exprNodeList, int sourceNo, int baseColumnNo, IDataSource dataSource) {
        return SQLPreoptimizerUtil.buildProjection(environment, exprNodeList, null, sourceNo, baseColumnNo, dataSource, null, null);
    }

    public static SQLValueList buildProjection(IPlanningEnvironment environment, List<IXQEQueryNode> exprNodeList, int sourceNo, int baseColumnNo, IDataSource dataSource, SQLQueryItemList sqlQueryItemList) {
        return SQLPreoptimizerUtil.buildProjection(environment, exprNodeList, null, sourceNo, baseColumnNo, dataSource, null, sqlQueryItemList);
    }

    public static SQLValueList buildProjection(IPlanningEnvironment environment, List<IXQEQueryNode> exprNodeList, BitMask vIncidence, int sourceNo, int baseColumnNo, IDataSource dataSource, List<SQLXid> xidList) {
        return SQLPreoptimizerUtil.buildProjection(environment, exprNodeList, null, sourceNo, baseColumnNo, dataSource, xidList, null);
    }

    public static SQLValueList buildProjection(IPlanningEnvironment environment, List<IXQEQueryNode> exprNodeList, BitMask vIncidence, int sourceNo, int baseColumnNo, IDataSource dataSource, List<SQLXid> xidList, SQLQueryItemList sqlQueryItemList) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLValueList vList = (SQLValueList)nodeFactory.createNode(301030);
        for (int i = 0; i < exprNodeList.size(); ++i) {
            SQLExpression exprNode = (SQLExpression)exprNodeList.get(i);
            IXQEQueryNode parent = exprNode.getParent();
            int position = parent.getPositionOfChild(exprNode);
            int columnNo = vList.indexOf(exprNode);
            if (columnNo < 0) {
                exprNode.move(vList);
                columnNo = vList.getNumberChildren() - 1;
            } else {
                parent.detachChild(exprNode);
            }
            SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
            fid.setSourceNo(sourceNo);
            fid.setColumnNo(columnNo);
            fid.setVirtualColumnNo(baseColumnNo + columnNo);
            fid.setDataType(exprNode.getDataType());
            fid.setIsNullable(exprNode.isNullable());
            if (exprNode.getType() == 301032) {
                fid.setQualifiers((SQLFid)exprNode);
                fid.setName(((SQLFid)exprNode).getName());
            }
            parent.addChild(fid, position);
        }
        if (xidList != null) {
            for (SQLXid xid : xidList) {
                if (vIncidence == null ? xid.getSourceNo() != sourceNo : !vIncidence.get(xid.getSourceNo())) continue;
                int columnNo = -1;
                columnNo = vList.indexOf(xid);
                if (columnNo >= 0) continue;
                SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
                xid.copyContentTo(nodeFactory, fid);
                vList.addChild(fid);
            }
        }
        boolean isColumnar = dataSource != null && DataSourceTypeEnum.isColumnar(dataSource.getType());
        boolean literalsInSelectList = false;
        String countStar = null;
        if (null != dataSource) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            literalsInSelectList = capabilities.getBooleanValue("supports.literalsInSelectList");
            countStar = capabilities.getStringValue("aggregates.CountStar", null);
        }
        if (vList.getNumberChildren() == 0 && sqlQueryItemList != null && (!literalsInSelectList || countStar == null || countStar.isEmpty())) {
            SQLFid fid = SQLBinderUtil.makeFid(environment, false, sqlQueryItemList, 0);
            fid.setTableName(((SQLQueryItem)sqlQueryItemList.get(0)).getTableName());
            vList.addChild(fid);
        } else if (vList.getNumberChildren() == 0 && !isColumnar) {
            SQLLiteral lit = (SQLLiteral)nodeFactory.createNode(301031);
            Value litValue = null;
            for (int state = 0; state < 4; ++state) {
                switch (state) {
                    case 0: {
                        lit.setDataType(DataTypeFactory.getCharType());
                        litValue = DataValueFactory.createCharValue();
                        litValue.set("0");
                        break;
                    }
                    case 1: {
                        lit.setDataType(DataTypeFactory.getVarcharType());
                        litValue = DataValueFactory.createVarcharValue();
                        litValue.set("1");
                        break;
                    }
                    case 2: {
                        lit.setDataType(DataTypeFactory.getIntegerType());
                        litValue = DataValueFactory.createIntegerValue();
                        litValue.set(0);
                        break;
                    }
                    case 3: {
                        lit.setDataType(DataTypeFactory.getDoubleType());
                        litValue = DataValueFactory.createDoubleValue();
                        litValue.set(0.0);
                        break;
                    }
                    default: {
                        throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedLiteralInProjection);
                    }
                }
                lit.setValue(litValue);
                if (dataSource == null || lit.isSupported(dataSource)) break;
                litValue = null;
            }
            if (litValue != null) {
                vList.addChild(lit);
            }
        }
        return vList;
    }

    public static List<SQLFilter> convertCnf(IPlanningEnvironment environment, SQLQueryBlock qBlock, IXQEQueryNode root, IXQEQueryNode fNode) {
        SQLQueryNode predicate = (SQLQueryNode)fNode.getChild(1);
        if (predicate.getType() == 301027 && ((SQLLogical)predicate).getSubType() == SQLLogical.SubType.AND) {
            SQLPreoptimizerUtil.split(environment, qBlock, root, (SQLQueryNode)predicate.detach());
            fNode.getChild(0).extract();
        }
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        while (fNode.getType() == 301009) {
            factorList.add((SQLFilter)fNode);
            fNode = fNode.getChild(0);
        }
        return factorList;
    }

    public static void split(IPlanningEnvironment environment, SQLQueryBlock qBlock, IXQEQueryNode root, SQLQueryNode predicate) {
        if (predicate.getType() == 301027 && ((SQLLogical)predicate).getSubType() == SQLLogical.SubType.AND) {
            SQLQueryNode lChild = (SQLQueryNode)predicate.getChild(0);
            SQLQueryNode rChild = (SQLQueryNode)predicate.getChild(1);
            SQLPreoptimizerUtil.split(environment, qBlock, root, lChild);
            SQLPreoptimizerUtil.split(environment, qBlock, root, rChild);
        } else {
            SQLPreoptimizerUtil.createFilterNode(environment, qBlock, root, predicate);
        }
    }

    private static void createFilterNode(IPlanningEnvironment environment, SQLQueryBlock qBlock, IXQEQueryNode root, SQLQueryNode predicate) {
        SQLFilter fNode = (SQLFilter)environment.getNodeFactory().createNode(301009);
        root.insertParent(fNode);
        if (predicate.getParent() == null) {
            fNode.addChild(predicate);
        } else {
            predicate.move(fNode);
        }
    }

    public static List<IXQEQueryNode> getProjectableExpressionsForGroupBy(SQLValueList vList) {
        ArrayList<IXQEQueryNode> list = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode child : vList.getChildren()) {
            SQLPreoptimizerUtil.getProjectableExpressionsForGroupBy((SQLQueryNode)child, list);
        }
        return list;
    }

    private static void getProjectableExpressionsForGroupBy(SQLQueryNode exprNode, List<IXQEQueryNode> exprList) {
        if (!exprNode.hasWindowedAggregates() && exprNode.isProjectableForGroupBy()) {
            exprList.add(exprNode);
            return;
        }
        for (int i = 0; i < exprNode.getNumberChildren(); ++i) {
            SQLPreoptimizerUtil.getProjectableExpressionsForGroupBy((SQLQueryNode)exprNode.getChild(i), exprList);
        }
    }

    public static void fixFieldIdentifiers(List<SQLFid> fidList, SQLQueryItemList qItems) {
        for (SQLFid fid : fidList) {
            int vColumnNo = 0;
            for (SQLQueryItem qItem : qItems) {
                if (qItem.getTableName() != null && qItem.getTableName().equals(fid.getTableName()) && qItem.getColumnNo() == fid.getColumnNo()) {
                    fid.setSourceNo(qItem.getSourceNo());
                    fid.setVirtualColumnNo(vColumnNo);
                    fid.setColumnNo(qItem.getColumnNo());
                }
                ++vColumnNo;
            }
        }
    }

    public static Ordering getWindowOrdering(SQLWindow window) {
        SQLComputeBreak computeBreak;
        SQLSortKeyList sortKeyList;
        Ordering ordering = new Ordering();
        SQLPartition partition = (SQLPartition)window.getFirstChildByType(301042);
        if (partition != null) {
            IXQEQueryNode[] partitionList = partition.getChildren();
            Ordering to = new Ordering(partitionList);
            ordering.merge(to);
        }
        if ((sortKeyList = (SQLSortKeyList)window.getFirstChildByType(301021)) != null) {
            IXQEQueryNode[] sortKeys = sortKeyList.getChildren();
            Ordering to = new Ordering(sortKeys);
            ordering.merge(to);
        }
        if ((computeBreak = (SQLComputeBreak)window.getFirstChildByType(301062)) != null) {
            IXQEQueryNode[] computeBreakList = computeBreak.getChildren();
            Ordering to = new Ordering(computeBreakList);
            ordering.merge(to);
        }
        return ordering;
    }

    public static List<IXQEQueryNode> getLeafNodes(IXQEQueryNode baseNode) {
        return SQLPreoptimizerUtil.getLeafNodes(baseNode, new ArrayList<IXQEQueryNode>());
    }

    private static List<IXQEQueryNode> getLeafNodes(IXQEQueryNode baseNode, List<IXQEQueryNode> leafNodes) {
        int nChildren = baseNode.getNumberChildren();
        if (baseNode.getType() == 301011 && ((SQLJoin)baseNode).getJoinType() != SQLJoin.SubType.CROSS) {
            --nChildren;
        }
        for (int i = 0; i < nChildren; ++i) {
            IXQEQueryNode child = baseNode.getChild(i);
            if (child.getType() == 301011) {
                SQLPreoptimizerUtil.getLeafNodes(child, leafNodes);
                continue;
            }
            leafNodes.add(child);
        }
        return leafNodes;
    }

    public static boolean canPushDownPredicate(SQLRangeVar rangeVar, IXQEQueryNode predicate) {
        boolean result = SQLPreoptimizerUtil.canPushDownPredicate(rangeVar);
        if (result) {
            IXQEQueryNode[] relations = predicate.getDescendantsOfType(301016, false);
            for (int i = 0; i < relations.length; ++i) {
                SQLRelation relation = (SQLRelation)relations[i];
                if (!relation.isWithClauseQueryRef() || !relation.getName().equals(rangeVar.getName())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean canPushDownPredicate(IXQEQueryNode root) {
        boolean result = false;
        if (root.getType() == 301007 || root.getType() == 301008 || root.getType() == 301009) {
            result = SQLPreoptimizerUtil.canPushDownPredicate(root.getChild(0));
        } else if (root.getType() == 301015) {
            SQLValueList vList = ((SQLProject)root).getOutputList();
            IXQEQueryNode[] aggregates = vList.getDescendantsOfType(301034, true);
            result = aggregates.length == 0;
        } else if (root.getType() == 301010) {
            result = true;
        }
        return result;
    }

    public static IXQEQueryNode getBaseNodeForPredicatePushDown(IXQEQueryNode root) {
        if (root.getType() == 301007 || root.getType() == 301008 || root.getType() == 301009) {
            return SQLPreoptimizerUtil.getBaseNodeForPredicatePushDown(root.getChild(0));
        }
        return root;
    }

    public static SQLQueryItemList getQueryItemList(SQLQueryItemList baseQueryItemList, SQLValueList vList) {
        SQLQueryItemList queryItems = SQLPreoptimizerUtil.getQueryItemList(vList);
        int i = 0;
        for (SQLQueryItem qItem : queryItems) {
            SQLQueryItem qItem2;
            IXQEQueryNode exprNode;
            if ((exprNode = vList.getChild(i++)).getType() != 301032 || (qItem2 = baseQueryItemList.getQueryItem((SQLFid)exprNode)) == null) continue;
            qItem.setIsParameter(qItem2.isParameter());
            qItem.setTableName(qItem2.getTableName());
        }
        return queryItems;
    }

    public static SQLQueryItemList getQueryItemList(SQLValueList vList) {
        SQLQueryItemList queryItems = new SQLQueryItemList();
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            SQLPreoptimizerUtil.addQueryItem(queryItems, (SQLQueryNode)vList.getChild(i));
        }
        return queryItems;
    }

    public static SQLQueryItem addQueryItem(SQLQueryItemList queryItems, SQLQueryNode exprNode) {
        SQLQueryItem qItem = new SQLQueryItem();
        if (exprNode.getType() == 301032) {
            SQLFid fid = (SQLFid)exprNode;
            qItem.setTableName(fid.getTableName());
            qItem.setName(fid.getName());
        }
        qItem.setSourceNo(0);
        qItem.setColumnNo(queryItems.size());
        qItem.setVirtualColumnNo(queryItems.size());
        qItem.setDataType(exprNode.getDataType());
        queryItems.add(qItem);
        return qItem;
    }

    public static List<SQLAggregate> findAggregatesWithNesting(SQLValueList list) {
        ArrayList<SQLAggregate> nestedAggs = new ArrayList<SQLAggregate>();
        List<IXQEQueryNode> aggrs = list.getFirstDescendantsOfTypeOrdered(301034, false);
        block0: for (IXQEQueryNode aggr : aggrs) {
            List<IXQEQueryNode> childAggrs = aggr.getDescendantsOfTypeOrdered(301034, false);
            for (IXQEQueryNode childAggr : childAggrs) {
                if (!((SQLAggregate)childAggr).isWindowedAggregate()) continue;
                nestedAggs.add((SQLAggregate)aggr);
                continue block0;
            }
        }
        return nestedAggs;
    }
}

