/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class SimplifySearchedCase
extends RQETransformation {
    public SimplifySearchedCase(int[] passNumbers) {
        this.mName = "Simplify searched case expression.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{301074};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode vList = node.getChild(0);
        IXQEQueryNode[] whenClauses = vList.getChildren();
        IDataType dataType = ((SQLQueryNode)node).getDataType();
        for (int i = 0; i < whenClauses.length; ++i) {
            IXQEQueryNode whenClause = whenClauses[i];
            if (whenClause.getChild(0).getType() != 301031) continue;
            Value value = ((SQLLiteral)whenClause.getChild(0)).getValue();
            boolean bValue = value.getBoolean();
            if (bValue) {
                for (int j = i; j < whenClauses.length; ++j) {
                    whenClauses[j].detach();
                }
                if (vList.getNumberChildren() == 0) {
                    IXQEQueryNode exprNode = whenClause.getChild(1).detach();
                    if (exprNode.getType() == 301050) {
                        exprNode = this.buildCastNode(environment, exprNode, dataType);
                    }
                    node.exchange(exprNode);
                    break;
                }
                if (node.getNumberChildren() == 2) {
                    node.getChild(1).detach();
                }
                node.addChild(whenClause.getChild(1));
                break;
            }
            whenClause.detach();
            if (vList.getNumberChildren() != 0) continue;
            IXQEQueryNode exprNode = node.getNumberChildren() == 2 ? node.getChild(1).detach() : factory.createNode(301050);
            if (exprNode.getType() == 301050) {
                int precision;
                if (whenClause.getChild(1).getType() == 301031 && (dataType.getCCLTypeCode() == 45 || dataType.getCCLTypeCode() == 55 || dataType.getCCLTypeCode() == 56) && (precision = dataType.getPrecision()) == 0) {
                    dataType = dataType instanceof CharType ? DataTypeFactory.getCharType(1) : (dataType instanceof VarcharType ? DataTypeFactory.getVarcharType(1) : DataTypeFactory.getDataType(dataType.getCCLTypeCode(), 1, 0));
                }
                exprNode = this.buildCastNode(environment, exprNode, dataType);
            }
            node.exchange(exprNode);
            break;
        }
    }

    private IXQEQueryNode buildCastNode(IPlanningEnvironment environment, IXQEQueryNode exprNode, IDataType dataType) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLDataType dTypeNode = (SQLDataType)factory.createNode(301037);
        dTypeNode.setDataType(dataType);
        IXQEQueryNode castNode = factory.createNode(301047);
        castNode.addChild(exprNode);
        castNode.addChild(dTypeNode);
        return castNode;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode[] whenClauses = node.getChild(0).getChildren();
        for (int i = 0; i < whenClauses.length; ++i) {
            IXQEQueryNode whenClause = whenClauses[i];
            if (whenClause.getChild(0).getType() != 301031 || !((SQLLiteral)whenClause.getChild(0)).getDataType().isBoolean()) continue;
            if (((SQLQueryNode)node).getDataType().getCCLTypeCode() == 22) break;
            status = true;
            break;
        }
        if (status) {
            this.traceQueryCondition(status, "Searched case expression can be simplified.", trace);
        } else {
            this.traceQueryCondition(status, "Searched case expression cannot be simplified.", trace);
        }
        return status;
    }
}

