/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class SimplifySimpleCase
extends RQETransformation {
    public SimplifySimpleCase() {
        this.mName = "Simplify simple case expression.";
        this.mPassNumbers = new int[]{5, 10};
        this.mTypes = new int[]{301073};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLLiteral inputExpr = (SQLLiteral)node.getChild(0);
        IXQEQueryNode vList = node.getChild(1);
        IXQEQueryNode[] whenClauses = vList.getChildren();
        IDataType dataType = ((SQLQueryNode)node).getDataType();
        for (int i = 0; i < whenClauses.length; ++i) {
            IXQEQueryNode whenClause = whenClauses[i];
            IXQEQueryNode resultExpr = whenClause.getChild(0);
            if (resultExpr.getType() != 301031) continue;
            boolean bValue = inputExpr.isSameExpression(resultExpr, false);
            if (bValue) {
                for (int j = i; j < whenClauses.length; ++j) {
                    whenClauses[j].detach();
                }
                if (vList.getNumberChildren() == 0) {
                    IXQEQueryNode exprNode = whenClause.getChild(1).detach();
                    if (exprNode.getType() == 301050) {
                        exprNode = this.buildCastNode(environment, exprNode, dataType);
                    }
                    node.exchange(exprNode);
                    break;
                }
                if (node.getNumberChildren() > 2) {
                    node.getChild(2).detach();
                }
                node.addChild(whenClause.getChild(1));
                break;
            }
            whenClause.detach();
            if (vList.getNumberChildren() != 0) continue;
            IXQEQueryNode exprNode = node.getNumberChildren() > 2 ? node.getChild(2).detach() : factory.createNode(301050);
            if (exprNode.getType() == 301050) {
                exprNode = this.buildCastNode(environment, exprNode, dataType);
            }
            node.exchange(exprNode);
            break;
        }
    }

    private IXQEQueryNode buildCastNode(IPlanningEnvironment environment, IXQEQueryNode exprNode, IDataType dataType) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLDataType dTypeNode = (SQLDataType)factory.createNode(301037);
        dTypeNode.setDataType(dataType);
        IXQEQueryNode castNode = factory.createNode(301047);
        castNode.addChild(exprNode);
        castNode.addChild(dTypeNode);
        return castNode;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getChild(0).getType() == 301031) {
            IXQEQueryNode[] whenClauses = node.getChild(1).getChildren();
            for (int i = 0; i < whenClauses.length && !status; ++i) {
                status = whenClauses[i].getChild(0).getType() == 301031;
            }
        }
        if (status) {
            boolean bl = status = ((SQLQueryNode)node).getDataType().getCCLTypeCode() != 22;
        }
        if (status) {
            this.traceQueryCondition(status, "Simple case expression can be simplified.", trace);
        } else {
            this.traceQueryCondition(status, "Simple case expression cannot be simplified.", trace);
        }
        return status;
    }
}

