/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.List;

public final class CollapseAdjacentProjections
extends RQETransformation {
    public CollapseAdjacentProjections() {
        this(6);
    }

    public CollapseAdjacentProjections(int passNumber) {
        this.mName = "Collapse adjacent SQLProject nodes.";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301010, 301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLProject child = (SQLProject)node.getChild(0);
        IXQEQueryNode vList = child.getOutputList().detach();
        SQLValueList vList1 = (SQLValueList)vList;
        SQLValueList vList2 = ((SQLProject)node).getOutputList();
        if (vList1.getAliasList() != null && vList2.getAliasList() == null) {
            List<SQLAlias> aliasList1 = vList1.getAliasList();
            ArrayList<SQLAlias> aliasList2 = new ArrayList<SQLAlias>();
            for (int i = 0; i < vList2.getNumberChildren(); ++i) {
                IXQEQueryNode exprNode = vList2.getChild(i);
                if (exprNode.getType() != 301032) continue;
                SQLFid fid = (SQLFid)exprNode;
                if (!fid.isFieldRef() && fid.getColumnNo() < aliasList1.size()) {
                    aliasList2.add(aliasList1.get(fid.getColumnNo()));
                    continue;
                }
                aliasList2.add(null);
            }
            vList2.setAliasList(aliasList2);
        }
        ArrayList<SQLFid> fidList = new ArrayList<SQLFid>();
        for (int i = 1; i < node.getNumberChildren(); ++i) {
            fidList.addAll(CollectionCast.downcast(node.getChild(i).getDescendantsOfTypeOrdered(301032, new int[]{301004, 301059}), IXQEQueryNode.class, SQLFid.class));
        }
        for (SQLFid fid : fidList) {
            if (fid.isFieldRef()) continue;
            fid.exchange(nodeFactory.deepCopyNode(vList.getChild(fid.getVirtualColumnNo())));
        }
        child.extract();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode child = node.getChild(0);
        boolean bl = status = child.getType() == 301015 && ((SQLProject)child).isCollapsible();
        if (status) {
            boolean bl2 = status = !CollapseAdjacentProjections.referencedAggregates(node, child);
        }
        if (status) {
            this.traceQueryCondition(status, "Projection node is adjacent to another projection node.", trace);
        } else {
            this.traceQueryCondition(status, "Projection node is not adjacent to another projection node.", trace);
        }
        return status;
    }

    static boolean referencedAggregates(IXQEQueryNode parent, IXQEQueryNode child) {
        SQLValueList vList = ((SQLProject)parent).getOutputList();
        List<IXQEQueryNode> aggrs = vList.getDescendantsOfTypeOrdered(301034, 301059);
        vList = ((SQLProject)child).getOutputList();
        for (IXQEQueryNode argr : aggrs) {
            List<IXQEQueryNode> fids = argr.getDescendantsOfTypeOrdered(301032, 301059);
            for (IXQEQueryNode fid : fids) {
                IXQEQueryNode node = vList.getChild(((SQLFid)fid).getVirtualColumnNo());
                List<IXQEQueryNode> refAggrs = node.getDescendantsOfTypeOrdered(301034, 301059);
                if (refAggrs.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

