/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.ArrayList;

public class Ordering {
    ArrayList<OrderItem> list = new ArrayList();

    public Ordering() {
    }

    public Ordering(IXQEQueryNode[] queryNodes) {
        this();
        for (int i = 0; i < queryNodes.length; ++i) {
            OrderItem item = new OrderItem(queryNodes[i]);
            this.list.add(item);
        }
    }

    public void addOrMerge(OrderItem anOrderItem) {
        boolean add = true;
        for (OrderItem item : this.list) {
            if (!item.isCompatible(anOrderItem)) continue;
            item.merge(anOrderItem);
            add = false;
            break;
        }
        if (add) {
            this.list.add(anOrderItem);
        }
    }

    public void merge(Ordering anOrdering) {
        for (int i = 0; i < anOrdering.size(); ++i) {
            this.addOrMerge(anOrdering.get(i));
        }
    }

    public boolean isCompatible(Ordering anOrdering) {
        int size = Math.min(anOrdering.size(), this.size());
        boolean compatible = true;
        for (int i = 0; i < size; ++i) {
            if (this.get(i).isCompatible(anOrdering.get(i))) continue;
            compatible = false;
            break;
        }
        return compatible;
    }

    public int size() {
        return this.list.size();
    }

    public OrderItem get(int index) {
        return this.list.get(index);
    }

    public static class OrderItem {
        static final int SORT_ASCENDING = 0;
        static final int SORT_DESCENDING = 1;
        static final int SORT_ASC_OR_DESC = 2;
        protected int order;
        protected SQLSortKey.NullOrdering nullOrder;
        protected SQLFid fid;

        public OrderItem(IXQEQueryNode queryNode) {
            if (queryNode.getType() == 301032) {
                this.fid = (SQLFid)queryNode;
                this.nullOrder = SQLSortKey.NullOrdering.UNSPECIFIED;
                this.order = 2;
            } else if (queryNode.getType() == 301020) {
                SQLSortKey sortKey = (SQLSortKey)queryNode;
                this.fid = (SQLFid)sortKey.getChild(0);
                this.order = sortKey.isAscending() ? 0 : 1;
                this.nullOrder = sortKey.getNullOrder();
            } else {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid node type");
            }
        }

        public boolean isCompatible(OrderItem aLightSortKey) {
            if (!this.fid.isSameExpression(aLightSortKey.fid, false)) {
                return false;
            }
            if (this.order != aLightSortKey.order && (this.order == 0 && aLightSortKey.order == 1 || this.order == 1 && aLightSortKey.order == 0)) {
                return false;
            }
            return this.nullOrder == aLightSortKey.nullOrder || (this.nullOrder != SQLSortKey.NullOrdering.NULLS_FIRST || aLightSortKey.nullOrder != SQLSortKey.NullOrdering.NULLS_LAST) && (this.nullOrder != SQLSortKey.NullOrdering.NULLS_LAST || aLightSortKey.nullOrder != SQLSortKey.NullOrdering.NULLS_FIRST);
        }

        public void merge(OrderItem anOrderItem) {
            if (this.order == 2) {
                this.order = anOrderItem.order;
            }
            if (this.nullOrder == SQLSortKey.NullOrdering.UNSPECIFIED) {
                this.nullOrder = anOrderItem.nullOrder;
            }
        }

        public SQLSortKey createSortKey(XQENodeFactory nodeFactory) {
            SQLSortKey sortKey = (SQLSortKey)nodeFactory.createNode(301020);
            sortKey.setNullOrder(this.nullOrder);
            if (this.order == 1) {
                sortKey.setAscending(false);
            }
            sortKey.addChild(nodeFactory.deepCopyNode(this.fid));
            return sortKey;
        }
    }
}

