/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.report;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.v5.binding.ConvertV5ExpressionToBinary;
import com.cognos.xqe.transformation.v5.binding.ExpandModelCalculations;
import com.cognos.xqe.transformation.v5.binding.ExpandModelFilters;
import com.cognos.xqe.util.Pair;
import com.cognos.xqemoser.IMoserModule;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.report.MoserModuleForReport;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CreateReportNode
extends Transformation {
    public static final String QUERYSET_REPORT = "reportQuerySet";
    public static final String REPORT_AS_DS = "reportAsDS";
    public static final String V5QUERY_REPORTQUERY = "v5QueryToReportQuery";

    public CreateReportNode() {
        this.mName = "CreateReportNode";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{101002};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(REPORT_AS_DS, Boolean.TRUE);
        this.createBinaryExpression(node, environment);
        MoserMetadataConnection[] mc = new MoserMetadataConnection[]{null};
        this.expandCalculationFilter(node, environment, mc);
        if (mc[0] == null) {
            mc[0] = this.getMoserMetadataConnection((V5QuerySet)node, environment);
        }
        List<IMoserModule> reportModules = mc[0].getModuleForReport();
        MoserModuleForReport moduleReport = (MoserModuleForReport)reportModules.get(0);
        List<V5Query> v5QueriesReport = moduleReport.getV5Queries(environment);
        String reportModelPath = moduleReport.getModelPath();
        String reportModelType = moduleReport.getModelType();
        String reportExpressionLocale = moduleReport.getExpressionLocale();
        TreeSet<String> requiredV5Report = new TreeSet<String>();
        Map<V5Query, Pair> v5QueryToReport = this.getV5QueryToReport(node, v5QueriesReport, requiredV5Report);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode t = nodeFactory.createNode(101111);
        node.addChild(t);
        t.setPropertyValue(V5QUERY_REPORTQUERY, v5QueryToReport);
        t.setPropertyValue("modelPath", reportModelPath);
        if (reportModelType != null && !reportModelType.isEmpty()) {
            t.setPropertyValue("modelType", reportModelType);
        }
        if (reportExpressionLocale != null && !reportExpressionLocale.isEmpty()) {
            t.setPropertyValue("expressionLocale", reportExpressionLocale);
        }
        if (requiredV5Report.isEmpty()) {
            return;
        }
        V5QuerySet subQuerySet = (V5QuerySet)nodeFactory.createNode(101002);
        t.addChild(subQuerySet);
        subQuerySet.setPropertyValue(QUERYSET_REPORT, Boolean.TRUE);
        for (V5Query subQ : v5QueriesReport) {
            subQuerySet.addChild(subQ);
        }
        for (String qName : requiredV5Report) {
            V5QueryResultDefinition subQRD = (V5QueryResultDefinition)nodeFactory.createNode(101055);
            subQRD.setRefQueryProperty(qName);
            subQRD.setPropertyValue("name", qName + "_qrd");
            subQuerySet.addChild(subQRD);
        }
    }

    protected Map<V5Query, Pair> getV5QueryToReport(IXQEQueryNode node, List<V5Query> v5QueriesReport, Set<String> requiredV5Report) {
        IXQEQueryNode[] v5queries;
        HashMap<V5Query, Pair> rt = new HashMap<V5Query, Pair>();
        HashSet<String> v5sReport = new HashSet<String>();
        for (V5Query q : v5QueriesReport) {
            v5sReport.add(q.getV5QueryName());
        }
        V5QuerySet querySet = (V5QuerySet)node;
        for (IXQEQueryNode v : v5queries = querySet.getChildrenOfType(101006)) {
            V5Query aV5query = (V5Query)v;
            V5Source src = aV5query.getV5Source();
            if (src == null || src.getNumberChildren() > 0 || src.getQueryRef() != null || src.getReferencedQueries() != null) continue;
            List<IXQEQueryNode> allParts = aV5query.getDescendantsOfTypeOrdered(201030, false);
            for (IXQEQueryNode p : allParts) {
                V5MultiPartIdentifier idObj = (V5MultiPartIdentifier)p;
                String[] parts = idObj.getNameParts();
                if (parts.length != 2 && !v5sReport.contains(parts[0])) continue;
                requiredV5Report.add(parts[0]);
                Pair pr = rt.get(aV5query);
                if (pr == null) {
                    pr = new Pair(new TreeSet(), new ArrayList());
                    rt.put(aV5query, pr);
                }
                ((Set)pr.getFirst()).add(parts[0]);
                ((List)pr.getSecond()).add(idObj);
            }
        }
        return rt;
    }

    protected void createBinaryExpression(IXQEQueryNode node, PlanningEnvironment environment) {
        int[] types = new int[]{101025, 101027, 101004, 101013, 101014};
        ArrayList<IXQEQueryNode> nodesToParse = new ArrayList<IXQEQueryNode>();
        nodesToParse.addAll(Arrays.asList(node.getDescendantsOfTypes(types, false)));
        for (IXQEQueryNode nodeToParse : nodesToParse) {
            Object prop = nodeToParse.getPropertyValue("expression");
            nodeToParse.removeProperty("expression");
            if (!(prop instanceof String) || nodeToParse.getNumberChildren() != 0) continue;
            String exp = (String)prop;
            try {
                IXQEQueryNode enode;
                if (exp.contains("#")) {
                    MacroExpander expander = new MacroExpander();
                    exp = expander.expand(nodeToParse, environment, exp);
                }
                if ((enode = ConvertV5ExpressionToBinary.precheckMoserCalculatedQueryItem(environment, nodeToParse, exp)) == null) {
                    enode = V5ExpressionProcessor.process(exp, environment, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale(), null, false);
                }
                if (enode == null) continue;
                nodeToParse.addChild(enode);
            }
            catch (XQERuntimeException xre) {
                ConvertV5ExpressionToBinary.handleException(environment, xre, nodeToParse, exp);
            }
        }
    }

    protected void expandCalculationFilter(IXQEQueryNode node, PlanningEnvironment environment, MoserMetadataConnection[] mc) {
        boolean b = true;
        while (b && (b = this.bindV5MultiPartIdentifierToCalculationFilter(node, environment, mc)) && (b = this.expandBoundCalculationFilter(node, environment))) {
        }
    }

    protected boolean bindV5MultiPartIdentifierToCalculationFilter(IXQEQueryNode node, PlanningEnvironment environment, MoserMetadataConnection[] mc) {
        List<IXQEQueryNode> allV5NodesToBind = node.getDescendantsOfTypeOrdered(201030, false);
        boolean b = false;
        for (IXQEQueryNode o : allV5NodesToBind) {
            IMetadata md;
            MetadataType tp;
            V5MultiPartIdentifier idObj = (V5MultiPartIdentifier)o;
            String[] parts = idObj.getNameParts();
            if (parts.length != 1 || !MoserModuleUtil.isValidIdentifier(parts[0])) continue;
            if (mc[0] == null) {
                mc[0] = this.getMoserMetadataConnection((V5QuerySet)node, environment);
            }
            if (MetadataType.FILTER != (tp = (md = mc[0].bindMetadataReference(parts[0])).getObjectType()) && MetadataType.CALCULATION != tp) continue;
            b = true;
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            newNode.setIdentifier(idObj.getIdentifier());
            newNode.setMetadata(md);
            if (idObj.getParent() != null) {
                idObj.exchange(newNode, false);
                continue;
            }
            idObj.detach();
        }
        return b;
    }

    protected boolean expandBoundCalculationFilter(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IXQEQueryNode> allV5NodesToExpand = node.getDescendantsOfTypeOrdered(201116, false);
        boolean b = false;
        int[] pn = new int[]{1};
        ExpandModelCalculations transformationCalc = new ExpandModelCalculations(pn);
        ExpandModelFilters transformationFilter = new ExpandModelFilters();
        for (IXQEQueryNode o : allV5NodesToExpand) {
            V5BoundModelIdentifier idObj = (V5BoundModelIdentifier)o;
            if (((Transformation)transformationCalc).passesNodeCondition((IXQEQueryNode)idObj, environment)) {
                b = true;
                ((Transformation)transformationCalc).apply((IXQEQueryNode)idObj, environment);
                continue;
            }
            if (!((Transformation)transformationFilter).passesNodeCondition((IXQEQueryNode)idObj, environment)) continue;
            b = true;
            ((Transformation)transformationCalc).apply((IXQEQueryNode)idObj, environment);
        }
        return b;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean b = (Boolean)node.getPropertyValue(QUERYSET_REPORT);
        if (Boolean.TRUE.equals(b)) {
            return false;
        }
        b = (Boolean)node.getPropertyValue(REPORT_AS_DS);
        if (Boolean.TRUE.equals(b)) {
            return false;
        }
        IXQEQueryNode[] t = node.getChildrenOfType(101111);
        if (t.length > 0) {
            return false;
        }
        V5QuerySet querySet = (V5QuerySet)node;
        String modelType = querySet.getModelType();
        if (!"module".equals(modelType)) {
            return false;
        }
        MoserMetadataConnection metadataConnection = this.getMoserMetadataConnection(querySet, environment);
        return metadataConnection != null && !metadataConnection.getModuleForReport().isEmpty();
    }

    protected MoserMetadataConnection getMoserMetadataConnection(V5QuerySet querySet, PlanningEnvironment environment) {
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        if (metadataConnection == null) {
            String modelPath = querySet.getModelPath();
            RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
            ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
            metadataConnection = MetadataService.getInstance().getConnection("MOSER", modelPath, execEnv, true);
            if (metadataConnection != null) {
                environment.setMetdataConnection(metadataConnection);
            }
        }
        if (metadataConnection instanceof MoserMetadataConnection) {
            return (MoserMetadataConnection)metadataConnection;
        }
        return null;
    }
}

