/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.report;

import com.cognos.i18n.NumericFormat;
import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.IMetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.Pair;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FinalizeReportNode
extends Transformation {
    public FinalizeReportNode() {
        this.mName = "FinalizeReportNode";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{101111};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Locale reportLC;
        IXQEQueryNode[] currentQueries;
        Map v5QueryToReport = (Map)node.getPropertyValue("v5QueryToReportQuery");
        String modelPath = (String)node.getPropertyValue("modelPath");
        String modelType = (String)node.getPropertyValue("modelType");
        String reportExprLocale = (String)node.getPropertyValue("expressionLocale");
        HashMap<String, V5Query> v5sNameReport = new HashMap<String, V5Query>();
        List<IXQEQueryNode> v5sreport = node.getDescendantsOfTypeOrdered(101006, false);
        V5QuerySet topQuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        for (IXQEQueryNode a : currentQueries = topQuerySet.getChildrenOfType(101006)) {
            FinalizeReportNode.markDataItemReferenced(a);
        }
        IXQEQueryNode[] currentQRDs = topQuerySet.getChildrenOfType(101055);
        for (IXQEQueryNode q : v5sreport) {
            V5Query reportQ = (V5Query)q;
            reportQ.setIsReferenced();
            FinalizeReportNode.markDataItemReferenced(q);
            v5sNameReport.put(reportQ.getV5QueryName(), reportQ);
            reportQ.move(topQuerySet);
        }
        for (IXQEQueryNode topQ : currentQueries) {
            V5Query topQuery = (V5Query)topQ;
            String nm = topQuery.getV5QueryName();
            if (!v5sNameReport.containsKey(nm)) continue;
            String newNm = nm + "_top_on_report";
            topQuery.setPropertyValue("name", newNm);
            for (IXQEQueryNode r : currentQRDs) {
                V5QueryResultDefinition topQRD = (V5QueryResultDefinition)r;
                if (!nm.equals(topQRD.getRefQueryProperty())) continue;
                topQRD.setRefQueryProperty(newNm);
            }
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (Map.Entry e : v5QueryToReport.entrySet()) {
            V5Query query = (V5Query)e.getKey();
            V5Source src = query.getV5Source();
            src.removeProperty("model");
            src.removeProperty("modelType");
            Set refQueriess = (Set)((Pair)e.getValue()).getFirst();
            src.setReferencedQueries(refQueriess);
            List partList = (List)((Pair)e.getValue()).getSecond();
            FinalizeReportNode.bindMultiPart(v5sNameReport, partList, nodeFactory);
        }
        topQuerySet.setPropertyValue("modelPath", modelPath);
        if (modelType != null) {
            topQuerySet.setPropertyValue("modelType", modelType);
        } else {
            topQuerySet.removeProperty("modelType");
        }
        MetadataConnection mc = environment.getMetadataConnection();
        if (mc != null) {
            environment.setMetdataConnection((IMetadataConnection)null);
        }
        if ((reportLC = FinalizeReportNode.getReportLocaleIfNeeded(reportExprLocale, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale())) != null) {
            ((RequestEnvironment)environment.getRequestEnvironment()).setExpressionLocale(reportLC);
        }
        node.detach();
    }

    public static Locale getReportLocaleIfNeeded(String reportExprLocale, Locale envLC) {
        int dialectEnv;
        if (reportExprLocale == null || reportExprLocale.isEmpty()) {
            return null;
        }
        Locale reportLC = LocaleConverter.strToLocale(reportExprLocale);
        if (envLC == null) {
            return reportLC;
        }
        int dialectReport = FinalizeReportNode.getDialect(reportLC);
        if (dialectReport == (dialectEnv = FinalizeReportNode.getDialect(envLC))) {
            return null;
        }
        return reportLC;
    }

    protected static int getDialect(Locale locale) {
        NumericFormat f = new NumericFormat(locale);
        char decSP = f.getDecimalSeparator();
        int dialect = 5;
        if (decSP == ',' || decSP == '\u066b') {
            dialect = 4;
        }
        return dialect;
    }

    public static void markDataItemReferenced(IXQEQueryNode q) {
        IXQEQueryNode[] allDIs;
        for (IXQEQueryNode d : allDIs = q.getDescendantsOfType(101003, false)) {
            V5DataItem di = (V5DataItem)d;
            di.setIsReferenced();
        }
    }

    public static void bindMultiPart(Map<String, V5Query> v5sNameReport, List<V5MultiPartIdentifier> partList, IXQENodeFactory nodeFactory) {
        for (V5MultiPartIdentifier partObj : partList) {
            String[] twoP = partObj.getNameParts();
            if (twoP.length != 2) continue;
            V5Query sQ = v5sNameReport.get(twoP[0]);
            if (sQ == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
            V5DataItem sDI = sQ.getDataItemByName(twoP[1]);
            if (sDI == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
            V5BoundDataItemReference newNode = (V5BoundDataItemReference)nodeFactory.createNode(201060);
            newNode.setIdentifier(partObj.getIdentifier());
            newNode.setRefDataItem(sDI);
            newNode.setIsQueryRefItem();
            partObj.exchange(newNode, false);
        }
    }
}

