/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.rsapi.RSAPIUtilities;

public class AddRSAPIGroupBody
extends Transformation {
    private static final String STRING_RASPI_INFO_COLLECTED = "RSAPIInfoCollected";

    public AddRSAPIGroupBody() {
        this.mName = "Add RS API group body data item references to a value set's rowset.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 0;
        this.mTypes = new int[1];
        this.mTypes[0] = 101051;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = false;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        RSAPIRowset parentRowset = (RSAPIRowset)parent.getPropertyValue("RSAPIEdgeRowset");
        if (parentRowset == null) {
            this.traceNodeCondition(status, "An RS API rowset is not available for the group body.", trace);
        } else {
            Boolean value = (Boolean)node.getPropertyValue(STRING_RASPI_INFO_COLLECTED);
            if (value == null || !value.booleanValue()) {
                status = true;
                this.traceNodeCondition(status, "No attempt has been made to add data items to the rowset.", trace);
            } else {
                this.traceNodeCondition(status, "Data items, if present, have already been assigned to the rowset.", trace);
            }
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        RSAPIEdgeRowset parentRowset = (RSAPIEdgeRowset)parent.getPropertyValue("RSAPIEdgeRowset");
        V5QueryResultDefinition qrdRoot = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        IXQEQueryNode[] dataItemRefs = node.getChildrenOfTypeOrdered(101015);
        RSAPIUtilities.transferV5DataItemsToRSAPIRowset(RSAPIUtilities.findAssociatedQuery(node), dataItemRefs, parentRowset, qrdRoot.isList());
        RSAPIUtilities.addPropertiesToRowset(node, environment, 2);
        node.setPropertyValue(STRING_RASPI_INFO_COLLECTED, Boolean.TRUE);
    }
}

