/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class IdentifyEmptyEdges
extends Transformation {
    public IdentifyEmptyEdges() {
        this.mName = "Identify those edges in the RS API result set that do not project data items.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 1;
        this.mTypes = new int[1];
        this.mTypes[0] = 401005;
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        RSAPIDataset dataset = (RSAPIDataset)node;
        if (dataset.isInvalidReport()) {
            this.traceNodeCondition(false, "The report layout has not yet been validated.", trace);
            return false;
        }
        if (!dataset.getEmptyEdgesIdentified()) {
            this.traceNodeCondition(true, "No attempt has bee made to identify the empty edges.", trace);
            return true;
        }
        this.traceNodeCondition(true, "Empty edges have already been identified, if present.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataset dataset = (RSAPIDataset)node;
        dataset.identifyEmptyEdges();
        environment.setTreeHasBeenModified();
    }
}

