/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5CaseExpression;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.types.CurrencyCodeType;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.data.types.HierarchyUniqueNameType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.LevelLabelType;
import com.cognos.xqe.data.types.LevelNumberType;
import com.cognos.xqe.data.types.LevelUniqueNameType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.types.MemberDescriptionType;
import com.cognos.xqe.data.types.MemberRollupType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.ParentLevelNumberType;
import com.cognos.xqe.data.types.ParentUniqueNameType;
import com.cognos.xqe.data.types.QueryItemModelIDType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.LoopDetectionChain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RSAPIUtilities {
    public static final String XMDX_NODE_ID = "xmdxNodeId";
    public static final int REF_DATA_ITEM_PROPERTIES = 1;
    public static final int GROUP_BODY_PROPERTIES = 2;
    public static final String PROP_USAGE = "usage";
    public static final String PROP_FDS_USAGE = "fdsUsage";
    public static final String PROP_USE_MODEL_LABELS_FOR_INDIRECT_MODELREFS = "useModelLabelsForIndirectModelRefs";

    private RSAPIUtilities() {
    }

    public static V5Query findAssociatedQuery(IXQEQueryNode node) {
        IXQEQueryNode qrd = node.getAncestorOfType(101055);
        String refQueryName = (String)qrd.getPropertyValue("refQuery");
        IXQEQueryNode querySet = node.getAncestorOfType(101002);
        IXQEQueryNode[] queries = querySet.getDescendantsOfType(101006, false);
        IXQEQueryNode query = null;
        for (int j = 0; j < queries.length; ++j) {
            String queryName = (String)queries[j].getPropertyValue("name");
            if (queryName.compareTo(refQueryName) != 0) continue;
            query = queries[j];
            break;
        }
        return (V5Query)query;
    }

    public static V5Query findQueryAssociatedWithDataset(IXQEQueryNode datasetNode) {
        Object parentNode;
        String refQueryName = ((RSAPIDataset)datasetNode).getRefQueryName();
        IXQEQueryNode querySet = datasetNode.getAncestorOfType(101002);
        IXQEQueryNode[] queries = querySet.getDescendantsOfType(101006, false);
        IXQEQueryNode query = null;
        for (int i = 0; i < queries.length; ++i) {
            String queryName = (String)queries[i].getPropertyValue("name");
            if (queryName.compareTo(refQueryName) != 0) continue;
            query = queries[i];
            break;
        }
        if (query != null && query.getPropertyValue(XMDX_NODE_ID) == null && querySet != null && (parentNode = querySet.getPropertyValue(XMDX_NODE_ID)) != null) {
            query.setPropertyValue(XMDX_NODE_ID, parentNode);
        }
        return (V5Query)query;
    }

    public static void transferV5DataItemsToRSAPIRowset(V5Query v5Query, IXQEQueryNode[] dataItemRefs, RSAPIRowset rsapiRowset, boolean listReport) {
        V5Selection selection = v5Query.getV5Selection();
        Boolean useModelLabelsForIndirectModelRefs = v5Query.getUseModelLabelsForIndirectModelRefs();
        if (dataItemRefs != null) {
            for (int i = 0; i < dataItemRefs.length; ++i) {
                V5DataItemRef v5DataItemRef = (V5DataItemRef)dataItemRefs[i];
                v5DataItemRef.setPropertyValue(PROP_USE_MODEL_LABELS_FOR_INDIRECT_MODELREFS, useModelLabelsForIndirectModelRefs);
                rsapiRowset.setDataItem(i, RSAPIUtilities.transferV5DataItemToRSAPIDataItem(v5DataItemRef, selection, listReport));
            }
        }
    }

    public static RSAPIDataItem transferV5DataItemToRSAPIDataItem(V5DataItemRef v5DataItemRef, V5Selection v5Selection, boolean listReport) {
        RSAPIDataItem result = RSAPIUtilities.transferV5DataItemToRSAPIDataItem((String)v5DataItemRef.getPropertyValue("refDataItem"), v5Selection, listReport);
        result.setUseModelLabelsForIndirectModelRefs(v5DataItemRef.getBooleanPropertyValue(PROP_USE_MODEL_LABELS_FOR_INDIRECT_MODELREFS, Boolean.FALSE));
        v5DataItemRef.setPropertyValue("RSAPIRefDataItem", result);
        return result;
    }

    public static RSAPIDataItem transferV5DataItemToRSAPIDataItem(String v5RefDataItemName, V5Selection v5Selection, boolean listReport) {
        RSAPIDataItem rsAPIDataItemRef = new RSAPIDataItem();
        rsAPIDataItemRef.setName(v5RefDataItemName);
        V5DataItem v5DataItem = v5Selection.getDataItemByRefName(v5RefDataItemName);
        RSAPIUtilities.copyDataItemInfo(v5DataItem, rsAPIDataItemRef, listReport);
        return rsAPIDataItemRef;
    }

    private static void copyDataItemInfo(V5DataItem v5DataItem, RSAPIDataItem rsAPIDataItem, boolean listReport) {
        AggregateTypeEnum aggr;
        IMetadata meta;
        String label;
        Integer solveOrder = (Integer)v5DataItem.getPropertyValue("solveOrder");
        if (solveOrder != null) {
            rsAPIDataItem.setSolveOrder(solveOrder);
        }
        if ((label = RSAPIUtilities.getLabelFromDataItem(v5DataItem)) != null) {
            rsAPIDataItem.setLabel(label);
        }
        RSAPIUtilities.copyMetadataInfo(v5DataItem, rsAPIDataItem);
        boolean isDirectModelRef = RSAPIUtilities.getIsDirectModelReference(v5DataItem, rsAPIDataItem);
        rsAPIDataItem.setDirectModelReference(isDirectModelRef);
        boolean isIndirectModelRef = RSAPIUtilities.getIsIndirectModelReference(v5DataItem, rsAPIDataItem);
        rsAPIDataItem.setIndirectModelReference(isIndirectModelRef);
        RSAPIUtilities.copyFormatInfo(v5DataItem, rsAPIDataItem, isDirectModelRef);
        RSAPIUtilities.assignDataItemType(v5DataItem, rsAPIDataItem, listReport);
        if (isDirectModelRef && (meta = rsAPIDataItem.getModelReference()) != null && meta instanceof MeasureWrapper && (aggr = ((MeasureWrapper)meta).getResolvedRegularAggregate()) != null) {
            rsAPIDataItem.setResolvedAggregateType(aggr.getModelName());
        }
        RSAPIUtilities.assignDataItemUsage(v5DataItem, rsAPIDataItem, listReport);
        RSAPIUtilities.setDataItemIsConstant(v5DataItem, rsAPIDataItem);
        rsAPIDataItem.setPreserveMetadata(v5DataItem.getPropPreserveMetadata());
        Parameter p = (Parameter)v5DataItem.getPropertyValue("linkParameter");
        if (p != null) {
            rsAPIDataItem.setLinkParam(p);
        }
    }

    private static String getLabelFromDataItem(V5DataItem v5DataItem) {
        V5BoundDataItemReference diRef;
        V5DataItem refDataItem;
        String label = (String)v5DataItem.getPropertyValue("label");
        if (label == null && v5DataItem.getChild(0).getType() == 201060 && null == (refDataItem = (diRef = (V5BoundDataItemReference)v5DataItem.getChild(0)).getRefDataItem()).getPropertyValue("isLabelFromModel")) {
            label = RSAPIUtilities.getLabelFromDataItem(refDataItem);
        }
        return label;
    }

    private static void assignDataItemType(V5DataItem v5DataItem, RSAPIDataItem rsAPIDataItem, boolean listReport) {
        IDataType dType = RSAPIUtilities.adjustDatatype(v5DataItem, rsAPIDataItem, listReport);
        if (!rsAPIDataItem.isMemberProperty()) {
            rsAPIDataItem.setDataType(dType);
        }
    }

    private static void assignDataItemUsage(V5DataItem v5DataItem, RSAPIDataItem rsAPIDataItem, boolean listReport) {
        RSAPIUsage usage;
        if (v5DataItem.isModuleCalculation()) {
            usage = RSAPIUsage.UNKNOWN;
        } else if (rsAPIDataItem.getDataType() == MemberType.MEMBERTYPE) {
            usage = RSAPIUsage.IDENTIFIER;
        } else {
            String usagePropFromDataItem = (String)v5DataItem.getPropertyValue(PROP_USAGE);
            if (usagePropFromDataItem != null) {
                usage = RSAPIUtilities.convertUsageStringToRSAPIUsage(usagePropFromDataItem);
            } else {
                IXQEQueryNode node = v5DataItem.getChild(0);
                usage = RSAPIUtilities.resolveExpressionUsage(node, listReport);
            }
        }
        rsAPIDataItem.setUsage(usage);
    }

    public static RSAPIUsage resolveExpressionUsage(IXQEQueryNode node, boolean listReport) {
        RSAPIUsage usage = RSAPIUsage.UNKNOWN;
        while (node != null && !node.isOfCategory(201120)) {
            node = node.getChild(0);
        }
        if (node == null) {
            usage = RSAPIUsage.UNKNOWN;
        } else if (node.getTypeObject() == 201098 || node.getTypeObject() == 201050) {
            usage = RSAPIUsage.ATTRIBUTE;
        } else if (node.isOfCategory(201124)) {
            usage = RSAPIUtilities.resolveAggregateFunctionUsage(node, listReport);
        } else if (node.isOfCategory(201116) || node.isOfCategory(201117)) {
            usage = RSAPIUtilities.resolveBoundItemUsage(node, listReport);
        } else if (node.isOfCategory(201060)) {
            V5DataItem dataItem = ((V5BoundDataItemReference)node).getRefDataItem();
            String usagePropFromDataItem = (String)dataItem.getPropertyValue(PROP_USAGE);
            usage = usagePropFromDataItem != null ? RSAPIUtilities.convertUsageStringToRSAPIUsage(usagePropFromDataItem) : RSAPIUtilities.resolveExpressionUsage(dataItem.getChild(0), listReport);
        } else if (node.isOfCategory(201122) || node.isOfCategory(201121)) {
            boolean calculatedMeasure = false;
            if (node.getType() == 201085) {
                IDimension dimension = MetadataUtil.getDimension(((V5MemberFunction)node).getMetadata());
                boolean bl = calculatedMeasure = dimension != null && dimension.isMeasuresDimension();
            }
            usage = calculatedMeasure ? RSAPIUsage.FACT : RSAPIUsage.IDENTIFIER;
        } else {
            V5DataItem dataItem;
            String usagePropFromDataItem;
            IDataType dt;
            usage = node.isOfCategory(201123) ? RSAPIUsage.FACT : (node.isOfCategory(201040) ? RSAPIUsage.FACT : (node.isOfCategory(201014) ? ((dt = ((V5ValueExpression)node).getDataType()) != null && dt.isNumeric() && ((V5ValueExpression)node).getSubType() != 0 ? RSAPIUsage.FACT : (node.getNumberChildren() == 1 ? RSAPIUtilities.resolveUsageByRules(node.getChild(0), null, listReport) : RSAPIUtilities.resolveUsageByRules(node.getChild(0), node.getChild(1), listReport))) : (node.isOfCategory(201125) ? RSAPIUtilities.resolveCalculationUsage(node, listReport) : (node.isOfCategory(201019) ? RSAPIUtilities.resolveExpressionUsage(node.getChild(1), listReport) : (node.isOfCategory(201103) ? RSAPIUsage.UNKNOWN : (node.isOfCategory(201097) ? ((usagePropFromDataItem = (String)(dataItem = ((V5BoundQueryItemReference)node).getRefDataItem()).getPropertyValue(PROP_USAGE)) != null ? RSAPIUtilities.convertUsageStringToRSAPIUsage(usagePropFromDataItem) : RSAPIUtilities.resolveExpressionUsage(dataItem.getChild(0), listReport)) : RSAPIUsage.UNKNOWN))))));
        }
        return usage;
    }

    private static RSAPIUsage resolveUsageByRules(IXQEQueryNode node1, IXQEQueryNode node2, boolean listReport) {
        RSAPIUsage leftUsage = RSAPIUtilities.resolveExpressionUsage(node1, listReport);
        if (leftUsage == RSAPIUsage.UNKNOWN) {
            return RSAPIUtilities.resolveExpressionUsage(node2, listReport);
        }
        RSAPIUsage rightUsage = RSAPIUtilities.resolveExpressionUsage(node2, listReport);
        if (rightUsage == RSAPIUsage.UNKNOWN) {
            return leftUsage;
        }
        if (leftUsage == RSAPIUsage.FACT || rightUsage == RSAPIUsage.FACT) {
            return RSAPIUsage.FACT;
        }
        if (leftUsage == RSAPIUsage.ATTRIBUTE || rightUsage == RSAPIUsage.ATTRIBUTE) {
            return RSAPIUsage.ATTRIBUTE;
        }
        if (leftUsage == RSAPIUsage.IDENTIFIER || rightUsage == RSAPIUsage.IDENTIFIER) {
            return RSAPIUsage.IDENTIFIER;
        }
        return RSAPIUsage.FACT;
    }

    private static RSAPIUsage resolveCalculationUsage(IXQEQueryNode node, boolean listReport) {
        String fdsUsage;
        RSAPIUsage ifThenElseUsage;
        RSAPIUsage usage = RSAPIUsage.UNKNOWN;
        usage = node.isOfCategory(201012) ? RSAPIUtilities.resolveExpressionUsage(node.getChild(0), listReport) : (node.isOfCategory(201017) ? ((ifThenElseUsage = RSAPIUtilities.resolveUsageByRules(node.getChild(1), node.getChild(2), listReport)) == RSAPIUsage.UNKNOWN ? RSAPIUtilities.resolveExpressionUsage(node.getChild(0), listReport) : ifThenElseUsage) : (node.isOfCategory(201018) ? (((V5CaseExpression)node).getSubType() == 0 ? RSAPIUtilities.resolveSimpleCaseExpressionUsage(node, listReport) : RSAPIUtilities.resolveSearchCaseExpressionUsage(node, listReport)) : ((fdsUsage = (String)node.getPropertyValue(PROP_FDS_USAGE)) != null ? RSAPIUtilities.convertUsageStringToRSAPIUsage(fdsUsage) : (node.getNumberChildren() == 0 ? RSAPIUsage.UNKNOWN : (node.getNumberChildren() == 1 ? RSAPIUtilities.resolveExpressionUsage(node.getChild(0), listReport) : RSAPIUtilities.resolveUsageByRules(node.getChild(0), node.getChild(1), listReport))))));
        return usage;
    }

    private static RSAPIUsage resolveSearchCaseExpressionUsage(IXQEQueryNode node, boolean listReport) {
        RSAPIUsage usage = RSAPIUsage.UNKNOWN;
        if (node.getNumberChildrenOfType(201019) == node.getNumberChildren()) {
            usage = RSAPIUtilities.resolveExpressionUsage(node.getChild(0), listReport);
        } else {
            IXQEQueryNode firstWhenClause = node.getChild(0);
            IXQEQueryNode elseStatement = node.getChild(node.getNumberChildren() - 1);
            usage = RSAPIUtilities.resolveUsageByRules(firstWhenClause, elseStatement, listReport);
        }
        return usage;
    }

    private static RSAPIUsage resolveSimpleCaseExpressionUsage(IXQEQueryNode node, boolean listReport) {
        RSAPIUsage usage = RSAPIUsage.UNKNOWN;
        if (node.getNumberChildrenOfType(201019) == node.getNumberChildren() - 1) {
            usage = RSAPIUtilities.resolveExpressionUsage(node.getChild(1), listReport);
        } else {
            IXQEQueryNode firstWhenClause = node.getChild(1);
            IXQEQueryNode elseStatement = node.getChild(node.getNumberChildren() - 1);
            usage = RSAPIUtilities.resolveUsageByRules(firstWhenClause, elseStatement, listReport);
        }
        return usage;
    }

    private static RSAPIUsage resolveAggregateFunctionUsage(IXQEQueryNode node, boolean listReport) {
        if (!listReport && node.isOfCategory(201124) && (node.getParent().getType() == 101004 || node.getParent().getType() == 101003)) {
            if (node.isOfCategory(201034) && ((V5SimpleNode)node).getSubType() != 14) {
                return RSAPIUsage.FACT;
            }
            return RSAPIUsage.IDENTIFIER;
        }
        int subType = ((V5AggregateFunction)node).getSubType();
        switch (subType) {
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 25: 
            case 26: {
                return RSAPIUtilities.resolveExpressionUsage(node.getChild(0), listReport);
            }
        }
        return RSAPIUsage.FACT;
    }

    private static RSAPIUsage resolveBoundItemUsage(IXQEQueryNode node, boolean listReport) {
        RSAPIUsage usage = RSAPIUsage.UNKNOWN;
        V5BoundToMetadata boundItem = (V5BoundToMetadata)node;
        IMetadata metadata = boundItem.getMetadata();
        usage = RSAPIUtilities.resolveMetadataUsage(metadata);
        return usage;
    }

    public static RSAPIUsage resolveMetadataUsage(IMetadata metadata) {
        RSAPIUsage usage = RSAPIUsage.UNKNOWN;
        MetadataType metadataType = metadata.getObjectType();
        if (metadataType == MetadataType.DIMENSION || metadataType == MetadataType.HIERARCHY || metadataType == MetadataType.LEVEL || metadataType == MetadataType.MEMBER) {
            usage = RSAPIUsage.IDENTIFIER;
            boolean isMeasureDimension = false;
            IDimension dimension = MetadataUtil.getDimension(metadata);
            if (dimension != null) {
                isMeasureDimension = dimension.isMeasuresDimension();
            }
            if (isMeasureDimension) {
                usage = RSAPIUsage.FACT;
            }
        } else if (metadataType == MetadataType.QUERY_ITEM) {
            String queryItemUsage = ((IQueryItem)metadata).getUsage();
            usage = RSAPIUtilities.convertUsageStringToRSAPIUsage(queryItemUsage);
        }
        return usage;
    }

    public static RSAPIUsage convertUsageStringToRSAPIUsage(String usageString) {
        RSAPIUsage usage = RSAPIUsage.UNKNOWN;
        if (usageString != null) {
            if (usageString.compareTo("attribute") == 0) {
                usage = RSAPIUsage.ATTRIBUTE;
            } else if (usageString.compareTo("identifier") == 0) {
                usage = RSAPIUsage.IDENTIFIER;
            } else if (usageString.compareTo("fact") == 0) {
                usage = RSAPIUsage.FACT;
            }
        }
        return usage;
    }

    private static void setDataItemModelReference(RSAPIDataItem rsAPIDataItem, IXQEQueryNode node) {
        if (node instanceof V5AggregateFunction && node.getNumberChildren() > 0) {
            node = node.getChild(0);
        }
        int[] memberSetTypes = new int[]{201106, 201107, 201108, 201047, 201048, 201049, 201064, 201066, 201071, 201149};
        if (node.getType() == 201113 && node.getNumberChildren() == 1 && node.getChild(0).isOfCategory(201123) && node.getChild(0).getNumberChildren() == 1) {
            node = node.getChild(0).getChild(0);
        } else if (node.isOfTypes(memberSetTypes)) {
            while (node.isOfTypes(memberSetTypes)) {
                node = node.getChild(0);
            }
            if (node.getType() == 101003) {
                node = node.getChild(0);
            }
        }
        if (node.getType() == 201116) {
            V5BoundModelIdentifier boundIdentifier = (V5BoundModelIdentifier)node;
            if (node.getParent().getType() != 101003 || !((V5DataItem)node.getParent()).isModuleCalculation()) {
                rsAPIDataItem.setModelReference(boundIdentifier.getMetadata());
                rsAPIDataItem.setQueryItemModelId(boundIdentifier.getIdentifier());
            }
        } else if (node.getType() == 201098) {
            V5RoleValueFunction roleValue = (V5RoleValueFunction)node;
            IMetadata metadata = null;
            RoleTypeEnum roleType = roleValue.getRoleType();
            if (roleType == RoleTypeEnum.MEMBER_CUSTOM_PROPERTY) {
                metadata = roleValue.getPropertyMetadata();
            }
            if (metadata == null && roleType.isIntrinsic() && roleType.toMDXKeyword() != null) {
                metadata = roleValue.getMetadata();
            }
            rsAPIDataItem.setModelReference(metadata);
            if (metadata == null && roleType.getDataType() == null) {
                rsAPIDataItem.setDataType(roleValue.getDataType());
                rsAPIDataItem.setIsCustomProperty(true);
            }
        }
    }

    private static void setDataItemIsConstant(V5DataItem v5DataItem, RSAPIDataItem rsAPIDataItem) {
        IXQEQueryNode dataItemNode = RSAPIUtilities.getBaseDataItemReference(v5DataItem);
        IXQEQueryNode node = dataItemNode.getChild(0);
        while (!node.isOfCategory(201120)) {
            node = node.getChild(0);
        }
        if (node.isOfCategory(201026)) {
            rsAPIDataItem.setIsConstant(true);
        }
    }

    private static IDataType adjustDatatype(V5DataItem v5DataItem, RSAPIDataItem rsAPIDataItem, boolean listReport) {
        IXQEQueryNode dataItemNode = RSAPIUtilities.getBaseDataItemReference(v5DataItem);
        IXQEQueryNode node = dataItemNode.getChild(0);
        while (!node.isOfCategory(201120)) {
            node = node.getChild(0);
        }
        if (!v5DataItem.isModuleCalculation()) {
            RSAPIUtilities.setDataItemModelReference(rsAPIDataItem, node);
        }
        if (v5DataItem.getModelCalculationID() != null) {
            rsAPIDataItem.setModelCalculationID(v5DataItem.getModelCalculationID());
        }
        V5SimpleNode v5Node = (V5SimpleNode)node;
        IDataType dType = v5Node.getDataType();
        IMetadata metadata = v5Node.getMetadata();
        if (metadata instanceof MeasureWrapper) {
            MeasureWrapper measure = (MeasureWrapper)metadata;
            AggregateTypeEnum aggregate = AggregateTypeEnum.valueOfV5String(measure.getV5AggregateAttribute());
            if (aggregate == AggregateTypeEnum.UNKNOWN && (aggregate = measure.getRegularAggregate()) == AggregateTypeEnum.UNSUPPORTED) {
                String aggregateName = RQPUtilities.getDefaultAggregateNameBasedOnDataType(dType);
                aggregate = AggregateTypeEnum.valueOfV5String(aggregateName);
            }
            if (!measure.getRefined()) {
                dType = aggregate.getPostAggregationDataType(dType);
            }
        }
        if (node.getType() == 201085) {
            dType = null;
            if (listReport) {
                boolean calculatedMeasure;
                IDimension dimension = MetadataUtil.getDimension(((V5MemberFunction)node).getMetadata());
                boolean bl = calculatedMeasure = dimension == null || dimension.isMeasuresDimension();
                if (!calculatedMeasure) {
                    dType = MemberType.MEMBERTYPE;
                }
            }
            if (dType == null) {
                dType = ((V5MemberFunction)node).getDefinitionDataType();
                if (dType == null) {
                    dType = MemberType.MEMBERTYPE;
                } else if (RSAPIUtilities.isCanonicalProperty(dType)) {
                    dType = RSAPIUtilities.getTypeUnderlyingCanonicalProperty(dType);
                }
            }
        }
        return dType;
    }

    public static boolean isCanonicalProperty(IDataType dType) {
        return dType == MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE || dType == ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE || dType == LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE || dType == LevelNumberType.LEVELNUMBERTYPE || dType == ParentLevelNumberType.DEFAULTPARENTLEVELNUMBERTYPE || dType == LevelLabelType.DEFAULTLEVELLABELTYPE || dType == CurrencyCodeType.DEFAULTCURRENCYCODETYPE || dType == MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE || dType == DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE || dType == HierarchyUniqueNameType.DEFAULTHIERARCHYUNIQUENAMETYPE || dType == MemberRollupType.DEFAULTMEMBERROLLUPTYPE || dType == MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE || dType == BusinessKeyType.DEFAULTBUSINESSKEYTYPE || dType == QueryItemModelIDType.DEFAULTQUERYITEMMODELIDTYPE;
    }

    private static IDataType getTypeUnderlyingCanonicalProperty(IDataType dType) {
        if (dType == MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE || dType == ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE || dType == LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE || dType == LevelLabelType.DEFAULTLEVELLABELTYPE || dType == CurrencyCodeType.DEFAULTCURRENCYCODETYPE || dType == MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE || dType == DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE || dType == HierarchyUniqueNameType.DEFAULTHIERARCHYUNIQUENAMETYPE || dType == MemberRollupType.DEFAULTMEMBERROLLUPTYPE || dType == MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE || dType == BusinessKeyType.DEFAULTBUSINESSKEYTYPE || dType == QueryItemModelIDType.DEFAULTQUERYITEMMODELIDTYPE) {
            return StringType.DEFAULTSTRINGTYPE;
        }
        if (dType == LevelNumberType.LEVELNUMBERTYPE) {
            return IntegerType.INTEGERTYPE;
        }
        return dType;
    }

    private static IXQEQueryNode getBaseDataItemReference(IXQEQueryNode node) {
        IXQEQueryNode child = node.getChild(0);
        while (!child.isOfCategory(201120)) {
            child = child.getChild(0);
        }
        if (child.getType() != 201060) {
            return node;
        }
        V5DataItem v5DataItem = ((V5BoundDataItemReference)child).getRefDataItem();
        if (v5DataItem == null) {
            return node;
        }
        return RSAPIUtilities.getBaseDataItemReference(v5DataItem);
    }

    private static boolean getIsDirectModelReference(IXQEQueryNode node, RSAPIDataItem rsAPIDataItem) {
        boolean isDirectModelReference;
        IXQEQueryNode child = node.getChild(0);
        boolean bl = isDirectModelReference = child.getType() == 201116 && ((V5BoundModelIdentifier)child).getMetadata() != null;
        if (isDirectModelReference && Boolean.TRUE.equals(child.getBooleanPropertyValue("isCollapsedHierarchyFunction"))) {
            isDirectModelReference = false;
        }
        return isDirectModelReference;
    }

    private static boolean getIsIndirectModelReference(IXQEQueryNode node, RSAPIDataItem rsAPIDataItem) {
        IXQEQueryNode baseDataItemRef = RSAPIUtilities.getBaseDataItemReference(node);
        return RSAPIUtilities.getIsDirectModelReference(baseDataItemRef, rsAPIDataItem);
    }

    public static void addPropertiesToRowset(IXQEQueryNode node, PlanningEnvironment environment, int propertyType) {
        RSAPIEdgeRowset rowset = propertyType == 1 ? (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset") : (RSAPIEdgeRowset)node.getParent().getPropertyValue("RSAPIEdgeRowset");
        IXQEQueryNode[] properties = node.getChildrenOfTypeOrdered(101054);
        DataType[] dataTypes = new DataType[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            V5RoleValueFunction roleValue = (V5RoleValueFunction)properties[i].getChild(0);
            if (roleValue == null) continue;
            dataTypes[i] = (DataType)roleValue.getDataType();
        }
        if (propertyType == 1) {
            rowset.setRefDataItemProperties(dataTypes);
        } else {
            rowset.setGroupBodyProperties(dataTypes);
        }
    }

    private static void copyMetadataInfo(V5DataItem v5DataItem, RSAPIDataItem rsAPIDataItem) {
        if (null != rsAPIDataItem.getModelReference()) {
            return;
        }
        LoopDetectionChain ldc = new LoopDetectionChain();
        HashMap<String, IMetadata> diToMD = new HashMap<String, IMetadata>();
        IMetadata metadata = RSAPIUtilities.getMetadataFromBoundIdentifier(v5DataItem, ldc, diToMD);
        if (null != metadata) {
            rsAPIDataItem.setModelReference(metadata);
            return;
        }
        metadata = RSAPIUtilities.getMetadataFromBoundMemberUniqueName(v5DataItem);
        if (null != metadata) {
            rsAPIDataItem.setModelReference(metadata);
            return;
        }
    }

    private static void copyFormatInfo(V5DataItem v5DataItem, RSAPIDataItem rsapiDataItem, boolean isDirectModelRef) {
        String format = v5DataItem.getFormat();
        if (format == null && isDirectModelRef && null != rsapiDataItem.getModelReference()) {
            IMetadata metadata = rsapiDataItem.getModelReference();
            if (metadata instanceof IMeasure && !MetadataService.hasROLAPDatasource(metadata.getConnection())) {
                format = ((IMeasure)metadata).getFormat();
            }
            if (format != null) {
                v5DataItem.setPropertyValue("customFormat", format);
            }
        }
    }

    private static IMetadata getMetadataFromBoundIdentifier(V5DataItem v5DataItem, LoopDetectionChain ldc, Map<String, IMetadata> diToMD) {
        String itemId = v5DataItem.getFullName();
        if (diToMD.containsKey(itemId)) {
            return diToMD.get(itemId);
        }
        if (!ldc.push(itemId)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, "Model Expression", ldc.serialize());
        }
        IMetadata metadataResult = null;
        boolean isMeasureResult = false;
        int[] types = new int[]{201060, 201116};
        IXQEQueryNode[] children = v5DataItem.getDescendantsOfTypes(types, false);
        if (children.length == 0) {
            diToMD.put(itemId, metadataResult);
            return metadataResult;
        }
        boolean isMetadataFromHierarchy = false;
        for (IXQEQueryNode childNode : children) {
            IMetadata metadata = null;
            if (childNode.getType() == 201116) {
                V5BoundModelIdentifier boundIdentifier = (V5BoundModelIdentifier)childNode;
                metadata = boundIdentifier.getMetadata();
            } else {
                V5BoundDataItemReference dataItemReference = (V5BoundDataItemReference)childNode;
                V5DataItem refDataItem = dataItemReference.getRefDataItem();
                metadata = RSAPIUtilities.getMetadataFromBoundIdentifier(refDataItem, ldc, diToMD);
            }
            boolean isMeasure = false;
            boolean isLevel = false;
            boolean isHierarchy = false;
            if (metadata == null) continue;
            MetadataType metadataType = metadata.getObjectType();
            switch (metadataType) {
                case LEVEL: {
                    isLevel = true;
                    break;
                }
                case MEASURE: {
                    isMeasure = true;
                    break;
                }
                case HIERARCHY: {
                    isHierarchy = true;
                    metadata = ((IHierarchy)metadata).getLevel(0);
                    break;
                }
                case QUERY_ITEM: {
                    metadata = ((IQueryItem)metadata).getLevel();
                    break;
                }
                case DIMENSION: {
                    if (((IDimension)metadata).getHierarchy(0) != null) {
                        metadata = ((IDimension)metadata).getHierarchy(0).getLevel(0);
                        break;
                    }
                    String param = metadata.getV5UniqueName();
                    XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedUseOfDimensionMetaObject, param, (IXQEQueryNode)v5DataItem);
                    throw new XQERuntimeException(message);
                }
                case CALCULATION: {
                    metadata = null;
                    break;
                }
                case MEMBER: {
                    if (MetadataType.isMeasure(metadata)) {
                        isMeasure = true;
                        break;
                    }
                    metadata = ((IMember)metadata).getLevel();
                    break;
                }
                case NAMED_SET: {
                    List<ILevel> levels = ((INamedSet)metadata).getLevels();
                    if (levels.isEmpty()) break;
                    metadata = levels.get(0);
                    break;
                }
            }
            if (metadata == null) continue;
            if (metadataResult == null) {
                metadataResult = metadata;
                if (isMeasure) {
                    isMeasureResult = true;
                }
                isMetadataFromHierarchy = isHierarchy;
                continue;
            }
            metadataType = metadata.getObjectType();
            IHierarchy resultHierarchy = MetadataUtil.getHierarchy(metadataResult);
            if (!isMeasureResult && metadataType == MetadataType.LEVEL && ((ILevel)metadata).getHierarchy() != resultHierarchy) {
                diToMD.put(itemId, null);
                return null;
            }
            if (isMeasure != isMeasureResult) {
                diToMD.put(itemId, null);
                return null;
            }
            if (!isMetadataFromHierarchy || !isLevel) continue;
            metadataResult = metadata;
            isMetadataFromHierarchy = false;
        }
        diToMD.put(itemId, metadataResult);
        return metadataResult;
    }

    private static IMetadata getMetadataFromBoundMemberUniqueName(V5DataItem v5DataItem) {
        IXQEQueryNode[] children = v5DataItem.getDescendantsOfType(201117, false);
        if (children.length > 0) {
            int i;
            IMetadata[] metadatas = new IMetadata[children.length];
            for (i = 0; i < children.length; ++i) {
                V5BoundMemberUniqueName v5mun = (V5BoundMemberUniqueName)children[i];
                metadatas[i] = v5mun.getLevel();
            }
            if (children.length > 0 && null != metadatas[0]) {
                for (i = 0; i < metadatas.length - 1; ++i) {
                    if (((ILevel)metadatas[i]).getHierarchy() == ((ILevel)metadatas[i + 1]).getHierarchy()) continue;
                    return null;
                }
                return metadatas[0];
            }
        }
        return null;
    }
}

