/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.XNoDataModeTree;
import com.cognos.xqe.trace.XQETrace;

public final class GenerateXNoDataModeTree
extends Transformation {
    public GenerateXNoDataModeTree() {
        this.mName = "Generate No Data Mode Run Tree.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{401005};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ((RequestEnvironment)environment.getRequestEnvironment()).setModelPath(querySet.getModelPath());
        XNoDataModeTree xNDMTree = (XNoDataModeTree)nodeFactory.createXNode(501131);
        node.getChild(0).insertParent(xNDMTree);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        int status = node.isValidPlannedQuery();
        if (status == -1) {
            this.traceQueryCondition(true, "The query is valid.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The query is not valid. Found issues in node " + status, trace);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        String nodeName = nodeFactory.getNodeTypeName(status);
        if (nodeName == null) {
            IXQEQueryNode faultyNode = (IXQEQueryNode)nodeFactory.getNodeIndex().getNodeByID(status);
            nodeName = faultyNode.getNodeTypeName();
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_V5PlanFailed, nodeName);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet v5QuerySet;
        Boolean bNoDataMode;
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getNumberChildren() > 0 && node.getParent().getType() == 101002;
        if (status && (null == (bNoDataMode = (v5QuerySet = (V5QuerySet)node.getParent()).getBooleanPropertyValue(V5QuerySet.RequestHint.NO_DATA_MODE.getPropertyName())) || !bNoDataMode.booleanValue())) {
            status = false;
        }
        if (status) {
            this.traceQueryCondition(status, "No Data Mode run tree has been generated.", trace);
        } else {
            this.traceQueryCondition(status, "No Data Mode run tree has not been generated.", trace);
        }
        return status;
    }
}

