/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MAMunQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.ma.XMAMunQuery;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameGenerator;

public class GenerateXMAMunQuery
extends Transformation {
    public static final String MODEL_SEPERATOR = "->";
    public static final String LOGICAL_SEPERATOR = ":";

    public GenerateXMAMunQuery() {
        this.mName = "Genarate an executable mun query node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1101029};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        this.traceQueryCondition(true, "A Mun Query node.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        XMAMunQuery xMunQuery = (XMAMunQuery)nodeFactory.createXNode(501136);
        MAMunQuery munQuery = (MAMunQuery)node;
        this.parseMUN(xMunQuery, munQuery.getMUN());
        node.exchange(xMunQuery);
    }

    private void parseMUN(XMAMunQuery query, String mun) {
        query.setPropertyValue("mun", mun);
        query.setPropertyValue("model", UniqueNameGenerator.extractLeftPartFromCognosMUN(mun));
        query.setPropertyValue("logical", UniqueNameGenerator.extractLogicalPartFromCognosMUN(mun));
        query.setPropertyValue("physical", UniqueNameGenerator.extractPhysicalPartFromCognosMUN(mun));
    }
}

