/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class ConvertOracleTimestamp
extends RQETransformation {
    public ConvertOracleTimestamp() {
        this.mName = "Convert oracle timestamp literal with 0 time to date.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301026, 301076, 301045};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] literals;
        IXQEQueryNode curNode = node;
        if (node.getType() == 301076) {
            curNode = node.getChild(1);
        }
        for (IXQEQueryNode literalNode : literals = curNode.getChildrenOfType(301031)) {
            SQLLiteral literal = (SQLLiteral)literalNode;
            Value lValue = literal.getValue();
            if (!this.literalNeedConversion(lValue)) continue;
            DateValue dateValue = (DateValue)DataTypeFactory.getDateType().createValue();
            dateValue.set(lValue);
            literal.setValue(dateValue);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        String conv = (String)environment.getMultiRequestContext().fetchXQEConfigurationProperty("queryExecution.convertOracleTimestamp[@value]", "");
        if (!"ORACLE:TRUE".equalsIgnoreCase(conv)) {
            return false;
        }
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        if (pQueryBlock == null) {
            return false;
        }
        IDataSource dataSource = pQueryBlock.getDataSource();
        if (dataSource == null || !DataSourceTypeEnum.isOracle(dataSource.getType())) {
            return false;
        }
        if (node.getType() == 301076) {
            IXQEQueryNode[] literals;
            if (node.getChild(0).getType() != 301032) {
                return false;
            }
            for (IXQEQueryNode literal : literals = node.getChild(1).getChildren()) {
                Value literalValue;
                if (literal.getType() != 301031 || !this.literalNeedConversion(literalValue = ((SQLLiteral)literal).getValue())) continue;
                return true;
            }
            return false;
        }
        if (node.getType() == 301045) {
            IXQEQueryNode[] literals;
            if (node.getChild(0).getType() != 301032) {
                return false;
            }
            for (IXQEQueryNode literal : literals = node.getChildrenOfType(301031)) {
                Value literalValue = ((SQLLiteral)literal).getValue();
                if (!this.literalNeedConversion(literalValue)) continue;
                return true;
            }
            return false;
        }
        IXQEQueryNode literal = null;
        switch (node.getChild(0).getType()) {
            case 301031: {
                if (node.getChild(1).getType() != 301032) break;
                literal = node.getChild(0);
                break;
            }
            case 301032: {
                if (node.getChild(1).getType() != 301031) break;
                literal = node.getChild(1);
                break;
            }
            default: {
                return false;
            }
        }
        if (literal == null) {
            return false;
        }
        Value literalValue = ((SQLLiteral)literal).getValue();
        return this.literalNeedConversion(literalValue);
    }

    private boolean literalNeedConversion(Value literalValue) {
        DateTimeValue lValue;
        return literalValue.getDataType().getCCLTypeCode() == 59 && (lValue = (DateTimeValue)literalValue).getHour() == 0 && lValue.getMinute() == 0 && lValue.getSecond() == 0 && lValue.getNanoseconds() == 0;
    }
}

