/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLComputeBreak;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.XAggregate;
import com.cognos.xqe.runtree.relational.XColumn;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.runtree.relational.olapengine.WindowDescriptor;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.CollectionCast;
import java.util.LinkedList;
import java.util.List;

public class GenerateXAggregate
extends RQETransformation {
    public GenerateXAggregate() {
        this.mName = "Generate XAggregate node.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        int i;
        SQLProject pNode = (SQLProject)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLValueList vList = pNode.getOutputList();
        IXQEQueryNode[] origOutputList = vList.getChildren();
        LinkedList<Integer> columnMap = new LinkedList<Integer>();
        List<XSetFunction> setFunctionList = CollectionCast.downcast(vList.getDescendantsOfTypeOrdered(501094, false), IXQEQueryNode.class, XSetFunction.class);
        XSetFunction[] functionList = new XSetFunction[setFunctionList.size()];
        setFunctionList.toArray(functionList);
        WindowDescriptor[] wdList = new WindowDescriptor[functionList.length];
        for (int i2 = 0; i2 < functionList.length; ++i2) {
            SQLWindow window = (SQLWindow)functionList[i2].getFirstChildByType(301041);
            wdList[i2] = this.createWindowDescriptor(window, columnMap);
            wdList[i2].setFunction(i2);
            window.detach();
        }
        int keySetLength = columnMap.size();
        List<XColumn> xList = CollectionCast.downcast(vList.getDescendantsOfTypeOrdered(501018, 501094), IXQEQueryNode.class, XColumn.class);
        for (int i3 = 0; i3 < xList.size(); ++i3) {
            XColumn xColumn = xList.get(i3);
            Integer colNo = xColumn.getColumnNo();
            if (columnMap.contains(colNo)) continue;
            columnMap.add(colNo);
        }
        int[] tempRowList = new int[columnMap.size()];
        for (i = 0; i < columnMap.size(); ++i) {
            tempRowList[i] = (Integer)columnMap.get(i);
        }
        block3: for (i = 0; i < xList.size(); ++i) {
            for (int j = 0; j < tempRowList.length; ++j) {
                XColumn xColumn = xList.get(i);
                if (xColumn.getColumnNo() != tempRowList[j]) continue;
                xColumn.setColumnNo(j);
                continue block3;
            }
        }
        for (i = 0; i < functionList.length; ++i) {
            XColumn xColumn = (XColumn)nodeFactory.createXNode(501018);
            xColumn.setContextNo(0);
            xColumn.setColumnNo(tempRowList.length + i);
            functionList[i].exchange(xColumn);
            IXQEQueryNode parent = xColumn.getParent();
            functionList[i].setParent(parent);
        }
        XExpression[] outputList = new XExpression[vList.getNumberChildren()];
        System.arraycopy(vList.getChildren(), 0, outputList, 0, vList.getNumberChildren());
        List<SQLAlias> aliasList = vList.getAliasList();
        if (aliasList != null) {
            for (int i4 = 0; i4 < aliasList.size(); ++i4) {
                SQLAlias alias = aliasList.get(i4);
                if (alias == null) continue;
                outputList[i4].setAlias(alias.getName());
            }
        }
        vList.detach();
        XAggregate xNode = (XAggregate)nodeFactory.createXNode(501093);
        for (int i5 = 0; i5 < origOutputList.length; ++i5) {
            origOutputList[i5].setParent(xNode);
        }
        xNode.setInputToIntermediateMap(tempRowList);
        xNode.setKeySetLength(keySetLength);
        xNode.setFunctionList(functionList);
        xNode.setOutputList(outputList);
        xNode.setWindowList(wdList);
        node.exchange(xNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLValueList list = ((SQLProject)node).getOutputList();
        IXQEQueryNode[] windows = list.getDescendantsOfType(301041, false);
        boolean bl = status = windows.length != 0;
        if (status) {
            this.traceQueryCondition(status, " Projection has SQLAggregate node.", trace);
        } else {
            this.traceQueryCondition(status, " Projection don't have a SQLAggregate node.", trace);
        }
        return status;
    }

    private WindowDescriptor createWindowDescriptor(SQLWindow window, List<Integer> columnMap) {
        Integer key;
        IXQEQueryNode[] nodeList;
        LinkedList<Integer> windowKeySet = new LinkedList<Integer>();
        SQLPartition partition = (SQLPartition)window.getFirstChildByType(301042);
        SQLSortKeyList order = (SQLSortKeyList)window.getFirstChildByType(301021);
        SQLComputeBreak computeBreak = (SQLComputeBreak)window.getFirstChildByType(301062);
        int orderByLength = 0;
        int partitionByLength = 0;
        WindowDescriptor wd = new WindowDescriptor();
        if (partition != null) {
            this.removeDuplicateFidNode(partition.getChildrenOfType(301032));
            partitionByLength = partition.getNumberChildren();
            wd.setPartitionByLength(partitionByLength);
            nodeList = partition.getChildrenOfTypeOrdered(301032);
            for (int i = 0; i < nodeList.length; ++i) {
                windowKeySet.add(((SQLFid)nodeList[i]).getVirtualColumnNo());
            }
        } else {
            wd.setPartitionByLength(0);
        }
        if (order != null) {
            nodeList = order.getDescendantsOfTypeOrdered(301032, false);
            for (IXQEQueryNode queryNode : nodeList) {
                key = ((SQLFid)queryNode).getVirtualColumnNo();
                if (windowKeySet.contains(key)) continue;
                ++orderByLength;
                windowKeySet.add(key);
            }
            wd.setOrderByLength(orderByLength);
        } else {
            wd.setOrderByLength(0);
        }
        if (computeBreak != null) {
            this.removeDuplicateFidNode(computeBreak.getChildrenOfType(301032));
            int computeBreakLength = Math.max(computeBreak.getNumberChildren(), partitionByLength);
            IXQEQueryNode[] nodeList2 = computeBreak.getChildrenOfTypeOrdered(301032);
            for (int i = 0; i < nodeList2.length; ++i) {
                key = ((SQLFid)nodeList2[i]).getVirtualColumnNo();
                if (windowKeySet.contains(key)) continue;
                windowKeySet.add(key);
                computeBreakLength = windowKeySet.size();
            }
            wd.setAtListLength(computeBreakLength);
        } else {
            wd.setAtListLength(0);
        }
        for (Integer integer : windowKeySet) {
            if (columnMap.contains(integer)) continue;
            columnMap.add(integer);
        }
        if (window.getWindowFrameLowerBound() != null && window.getWindowFrameUpperBound() != null) {
            wd.setWindowStart(window.getWindowFrameLowerBound());
            wd.setWindowEnd(window.getWindowFrameUpperBound());
        } else if (window.getWindowFrameLowerBound() != null && window.getWindowFrameUpperBound() == null) {
            wd.setWindowStart(window.getWindowFrameLowerBound());
            wd.setWindowEnd(0);
        } else if (window.getWindowFrameLowerBound() == null && window.getWindowFrameUpperBound() == null) {
            wd.setWindowStart(Integer.MAX_VALUE);
            wd.setWindowEnd(Integer.MAX_VALUE);
        }
        return wd;
    }

    private void removeDuplicateFidNode(IXQEQueryNode[] nodeList) {
        LinkedList<Integer> fidList = new LinkedList<Integer>();
        for (int i = 0; i < nodeList.length; ++i) {
            Integer key = ((SQLFid)nodeList[i]).getVirtualColumnNo();
            if (!fidList.contains(key)) {
                fidList.add(key);
                continue;
            }
            nodeList[i].extract();
        }
    }
}

