/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.qep.QEPGroupBy;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.XColumn;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XGroupBy;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.ArrayList;
import java.util.List;

public class GenerateXGroupBy
extends RQETransformation {
    public GenerateXGroupBy() {
        this.mName = "Generate XGroupBy node.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{901020};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        XGroupBy xNode = (XGroupBy)factory.createXNode(501023);
        this.apply(node, xNode, factory);
    }

    /*
     * WARNING - void declaration
     */
    protected void apply(IXQEQueryNode node, XGroupBy xNode, XQENodeFactory factory) {
        int j;
        QEPGroupBy groupBy = (QEPGroupBy)node;
        SQLValueList vList = (SQLValueList)groupBy.getChild(1);
        SQLGroupByList gList = groupBy.getGroupByList();
        IXQEQueryNode[] origOutputList = vList.getChildren();
        int nGroupCols = 0;
        if (gList != null) {
            nGroupCols = gList.getNumberChildren();
        }
        int[] groupCols = new int[nGroupCols];
        for (int i = 0; i < nGroupCols; ++i) {
            if (((SQLQueryNode)gList.getChild(i)).getDataType().isBlob()) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_GroupByNotAllowed);
            }
            if (gList.getChild(i).getType() != 301032) continue;
            SQLFid fid = (SQLFid)gList.getChild(i);
            groupCols[i] = fid.getVirtualColumnNo();
        }
        List<IXQEQueryNode> list = vList.getDescendantsOfTypeOrdered(501018, new int[]{501038, 501098});
        ArrayList<Integer> nonGroupingColumns = new ArrayList<Integer>();
        for (XColumn xColumn : list) {
            int columnNo = xColumn.getColumnNo();
            boolean add = true;
            for (j = 0; j < groupCols.length; ++j) {
                if (columnNo != groupCols[j]) continue;
                add = false;
                break;
            }
            if (!add) continue;
            for (Integer integer : nonGroupingColumns) {
                if (integer != columnNo) continue;
                add = false;
                break;
            }
            if (!add) continue;
            nonGroupingColumns.add(new Integer(columnNo));
        }
        int[] nonGroupCols = new int[nonGroupingColumns.size()];
        if (nonGroupingColumns.size() > 0) {
            void var13_16;
            boolean bl = false;
            while (var13_16 < nonGroupCols.length) {
                nonGroupCols[var13_16] = (Integer)nonGroupingColumns.get((int)var13_16);
                ++var13_16;
            }
        }
        block5: for (int i = 0; i < list.size(); ++i) {
            boolean bl = false;
            XColumn xColumn = (XColumn)list.get(i);
            for (j = 0; j < groupCols.length; ++j) {
                if (xColumn.getColumnNo() != groupCols[j]) continue;
                xColumn.setColumnNo(j);
                bl = true;
                break;
            }
            for (j = 0; j < nonGroupCols.length && !bl; ++j) {
                if (xColumn.getColumnNo() != nonGroupCols[j]) continue;
                xColumn.setColumnNo(groupCols.length + j);
                continue block5;
            }
        }
        List<IXQEQueryNode> setFunctionList = vList.getDescendantsOfTypeOrdered(501038, false);
        XSetFunction[] functionList = new XSetFunction[setFunctionList.size()];
        setFunctionList.toArray(functionList);
        for (int i = 0; i < functionList.length; ++i) {
            XColumn xColumn = (XColumn)factory.createXNode(501018);
            xColumn.setContextNo(0);
            xColumn.setColumnNo(groupCols.length + nonGroupCols.length + i);
            functionList[i].exchange(xColumn);
            IXQEQueryNode parent = xColumn.getParent();
            functionList[i].setParent(parent);
        }
        if (gList != null) {
            groupBy.detachChild(gList);
        }
        groupBy.detachChild(vList);
        XExpression[] outputList = new XExpression[vList.getNumberChildren()];
        System.arraycopy(vList.getChildren(), 0, outputList, 0, vList.getNumberChildren());
        List<SQLAlias> aliasList = vList.getAliasList();
        if (aliasList != null) {
            for (int i = 0; i < aliasList.size(); ++i) {
                SQLAlias alias = aliasList.get(i);
                if (alias == null) continue;
                outputList[i].setAlias(alias.getName());
            }
        }
        for (int i = 0; i < origOutputList.length; ++i) {
            origOutputList[i].setParent(xNode);
        }
        xNode.setOutputList(outputList);
        xNode.setFunctionList(functionList);
        xNode.setGroupByList(groupCols);
        xNode.setNonGroupByList(nonGroupCols);
        node.exchange(xNode, true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XValueDecoration valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043);
        boolean bl = status = valueDecorationNode == null || !valueDecorationNode.isVectorized();
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        }
        return status;
    }
}

